<?php
// all blog comments ordered by time.
class CommentdatesFileIndex extends BaseHashOfDatesFileIndex {
  public $indexName = 'comment-dates';

  function PostMoved($post, $newName, &$info) {
    foreach ($this->Select() as $comment => $time) {
      if (BComments::PostOf($comment) === $post) {
        $this->Rename($comment, BComments::ReferrerFor($newName, $comment));
      }
    }
  }

  function CommentAdded($parent, $comment, &$info) {
    $this->Add($comment, $info['time']);
  }

  function Rebuild() {
    $this->Clear();

    foreach (BComments::AllRecursive() as $post => $comments) {
      foreach ($comments as $comment) {
        $this->Add($comment, BComments::Get($comment, 'time'));
      }
    }
  }
}
