<?php
// array of information regarding a registered plugin:
// 'My plugin' => array( 'files' => array('/home/blog/plugins/File.php', '/.../other.ini', ...) )
class PluginsFileIndex extends BaseHashOfHashFileIndex {
  public $indexName = 'plugins';

  function Select($plugin = null) {
    return parent::Select($plugin === null ? null : strtolower($plugin));
  }

  function Add($plugin, $info) { parent::AddKey(strtolower($plugin), $info); }
  function Remove($plugin) { parent::Remove(strtolower($plugin)); }

  function Rename($plugin, $field, $newFieldName) {
    parent::Rename(strtolower($plugin), $field, $newFieldName);
  }
}
