<?php

class PostNormalizer {
  static function Format(&$text, $post, &$info) {
    isset( $info['permalink'] ) or $info['permalink'] = '';

    // note the &link - it's important because we don't know the permalink yet
    // so we render (ToHTML()) the doc later once it's determined.
    $options = array('pageForSelfAnchorLinks' => &$info['permalink'], 'post' => $post);
    $options['allowedFormats'] = BConfig::AllowedFormatsForPosts();
    $doc = BUverseWiki::Format($text, $post, $options);
    $info += compact('doc') + $doc->meta;

    $info['source'] = $text;

    $info['postTitle'] = $doc->HtmlTitle();
    $info['textTitle'] = strip_tags( $info['postTitle'] );
  }

  static function AddShortenFields(&$text, $post, &$info) {
    $docCopy = BConfig::$reuseRenderedDoc ? $info['doc'] : BUverseWiki::Format($text, $post);
    $options = array('isTruncated' => &$info['isTruncated'], 'fullURL' => $info['permalink'],
                     'softLimit' => BConfig::$extraShortenCount);
    $info['shortened'] = BPosts::Shorten($docCopy, BConfig::$shortenCount, $options);

    if (BConfig::$shortenCountForThreads < 1) {
      $info['shortenedForThread'] = '';
    } else {
      $docCopy = BConfig::$reuseRenderedDoc ? $info['doc'] : BUverseWiki::Format($text, $post);
      $options = array('softLimit' => 1, 'fullURL' => $info['permalink']);
      $info['shortenedForThread'] = BPosts::Shorten($docCopy, BConfig::$shortenCountForThreads, $options);
    }
  }

  static function NormCommonFields(&$text, $post, &$info) {
    $info += array(
      'synopsis' => '', 'nutshell' => '', 'related' => array(), 'commenting' => null,
      'tags' => array(), 'lastChanged' => null, 'links' => array()
    );

    $fields = array('dateWritten' => '{{DateWritten}}', 'postTitle' => '==Title==',
                    'author' => '{{Author}}');

      foreach ($fields as $field => $desc) {
        if (trim( $info[$field] ) === '') {
          $post and $post = " $post";
          throw new BException("Mandatory $desc is missing in post$post.");
        }
      }

    if (($info['synopsis'] === '') ^ ($info['nutshell'] === '')) {
      $info['synopsis'] !== '' ? ($info['nutshell'] = $info['synopsis'])
                               : ($info['synopsis'] = $info['nutshell']);
    }
  }

  static function NormMetaFields(&$text, $post, &$info) {
    $cat = &$info['category'];
    if (!isset($cat) or ( count($cat) === 1 and in_array($cat[0], range(-5, -1)) )) {
      if (BConfig::$categoryFromPath and dirname($post) !== '.') {
        $utf8Path = dirname($post);   // note that post names are already in UTF-8.
        $path = preg_split('/[\\/]/u', $utf8Path, -1, PREG_SPLIT_NO_EMPTY);

        $cat = isset($cat) ? array_slice($path, 0, $cat[0]) : $path;
      } else {
        $cat = array();
      }
    }

    $info['tags'] = array_merge($info['tags'], $info['category']);
    $info['tags'] = array_unique($info['tags']);
    sort($info['tags']);

    $info['postTime'] = $info['dateWritten'];
    foreach ($info['related'] as &$post) { $post .= BConfig::$postFileExt; }

    $extraLinks = array();
    $info['permalink'] = BPosts::PermalinkFor($info, $extraLinks, $post);
    $info['links'] = array_merge($info['links'], $extraLinks);

    // note: only render after 'permalink' has been set - see ::Format().
    $info['page'] = $info['doc']->ToHTML();
  }

  // todo: move to events
  static function NormImageFields(&$text, $post, &$info) {
    static $scaleFields = array('image250' => 250, 'image500' => 500, 'thumbnail' => 100);
    $fields = array('image' => 0) + $scaleFields;

      foreach ($fields as $field => $size) {
        if (!isset($info[$field])) {
          $base = ChangeStrExt($post, $size ? " - {$size}px" : '');
          $base = BConfig::FromUTF8('file name', BConfig::FileOf('posts', $base));
          if ($file = FindImage($base)) {
            $info[$field] = BConfig::ToUTF8('file name', basename($file));
          }
        }
      }

    if (empty( $info['image'] )) {
      $added = array();
    } else {
      $added = self::MakeDefaultImages($scaleFields, $info['image'], $post, $info);
    }

    $utf8Path = dirname($post);
    foreach ($fields as $field => $size) {
      if (!isset($info[$field])) {
        $info[$field] = '';
      } elseif ($info[$field] !== '' and !isset($added[$field])) {
        $info[$field] = BConfig::$postURL."$utf8Path/".$info[$field];
      }
    }
  }

    static function MakeDefaultImages($scaleFields, $baseImage, $post, &$info) {
      $added = array();

      dirname($post) === '' or $baseImage = dirname($post)."/$baseImage";
      $baseImage = BConfig::FileOf('posts', $baseImage);
      $baseImageNative = BConfig::FromUTF8('file name', $baseImage);

      list($imageWidth, $imageHeight) = getimagesize($baseImageNative);
      if (!is_int($imageWidth)) {
        throw new BException("Attached image $baseImage doesn't exist.");
      }

      foreach ($scaleFields as $field => $maxSize) {
        if (!isset($info[$field])) {
          $info[$field] = '';

          if ($imageHeight > $maxSize or $imageWidth > $maxSize) {
            $thumbFile = BConfig::FileOf('thumbs', "$post-$field");
            $ext = ExtOf($baseImageNative);
            $thumbFile .= $ext;

            $thumbFileNative = BConfig::FromUTF8('file name', $thumbFile);
            $thumbFile = null;    // to avoid confusion in the code by changing both this and *Native.

            if (!is_file($thumbFileNative) or filemtime($thumbFileNative) < filemtime($baseImageNative)) {
              MkDirOf($thumbFileNative);
              ScaleImage(array($baseImageNative, substr($ext, 1)), $maxSize, $thumbFileNative);
            }

            $info[$field] = BConfig::$thumbsURL."$post-$field".$ext;
            $added[$field] = true;
          }
        }
      }

      return $added;
    }
}
