<?php

class SiteLock {
  static $file;
  protected static $info;

  static function Check() {
    if (self::IsLocked()) {
      if ($d = self::SecLeft() and $d <= 2) {
        while ($d-- > 0) {
          sleep(1);
          if (!self::IsLocked()) { return; }
        }
      }

      BEvent::Fire('on site lock');
    }
  }

  static function Info($key = null) {
    if (!self::IsLocked()) { throw ESiteLockInactive(); }

    if (!self::$info) {
      @list($deadline, $extra, $msg) = explode("\n", file_get_contents(self::$file), 3);
      $deadline = (int) trim($deadline);
      self::$info = array('deadline' => $deadline <= time() ? 0 : $deadline,
                          'extra' => trim($extra), 'message' => trim($msg));
    }

    return $key ? self::$info[$key] : self::$info;
  }

  static function IsLocked() {
    // PHP manual: "PHP doesn't cache information about non-existent files".
    return !is_file(self::$file) ? false : (clearstatcache() or is_file(self::$file));
  }

  static function Deadline() { return self::Info('deadline'); }
  static function SecLeft() { return self::Deadline() - time(); }

  static function ExtraFields($field = null) {
    $info = self::Info('extra');
    $extra = trim($info['extra'], '{}') !== '' ? unserialize($info['extra']) : array();
    return $field ? $extra[$field] : $extra;
  }

  static function Message($new = null) {
    if ($new === null) {
      return Translate( self::Info('message') );
    } else {
      self::Info();
      self::$info['message'] = $new;
      file_put_contents(self::$file, join("\n", self::$info), LOCK_EX);
    }
  }

  static function TryLocking($message = '', $forSec = null) {
    if (!self::IsLocked()) {
      self::Lock($message, $forSec);
      return true;
    }
  }

  static function Lock($message = '', $forSec = null) {
    $file = ($forSec ? time() + $forSec : '0')."\n{}\n$message";
    file_put_contents(self::$file, $file, LOCK_EX);
  }

  static function Unlock() { is_file(self::$file) and unlink(self::$file); }
}

class ESiteLockInactive extends BException {
  function __construct($field = null) {
    parent::__construct('Cannot get lock '.($field ? $field : 'info').' - site lock is inactive.');
  }
}

SiteLock::$file = BConfig::$enginePath.'site.lock';
