<?php

// only for debug, is not used in the code.
function v($var) { call_user_func_array('var_dump', func_get_args()); }

function Translate($str, $arg_1 = null) {
  $trans = &BConfig::$strings[$str];
  $str = isset($trans) ? $trans : $str;

  if (isset($arg_1)) {
    $args = func_get_args();
    $args[0] = $str;
    return call_user_func_array('sprintf', $args);
  } else {
    return $str;
  }
}

  function TranslateNumber($langName, $number) {
    $sentense = BConfig::$strings[$langName];
    if (!$sentense) {
      throw new BException("Cannot translate number as $langName - no language string found.");
    }

      $numLang = @BConfig::$strings["$langName num"];
      if (!isset($numLang)) {
        $numLang = $sentense;
        $sentense = '$';
      }

    $rolls = substr($numLang, -1) === '*';
    $infl = explode( ',', rtrim($numLang, '*') );  // $ , , , , *
    foreach ($infl as &$str) { $str = trim($str); }

    $stem = array_shift($infl);
    $word = DateFmt::FmtNumUsing($stem, $infl, $rolls, $number);

    return SimpleFmt($sentense, SimpleFmt($word, $number));
  }

// taken from StdTpl's templater.php. Also exists in UWikiBaseElement.
function SimpleFmt($pattern, $arg_1) {
  global $SimpleFmtArgs;
  $SimpleFmtArgs = func_get_args();
  array_shift($SimpleFmtArgs);

  if ($pattern === '$') {
    return $arg_1;
  } else {
    return preg_replace_callback('/\$(\$?)/u', 'SimpleFmtCallback', $pattern);
  }
}

  function SimpleFmtCallback($match) {
    global $SimpleFmtArgs;

    if ($match[1] === '') {
      if ($SimpleFmtArgs) {
        return array_shift($SimpleFmtArgs);
      } else {
        throw new BException('No arguments left for SimpleFmt().');
      }
    } else {
      return '$';
    }
  }

function strtr8($str, $replaces, $strWith = null) {
  is_array($replaces) or $replaces = (array) $replaces;

  if (is_array($strWith)) {
    $replaces = array_combine($replaces, $strWith);
  } elseif ($strWith !== null) {
    $replaces = array_fill_keys($replaces, $strWith);
  }

  $allFrom = $allTo = array();
  foreach ($replaces as $from => $to) {
    $allFrom[] = '~'.preg_quote($from, '~').'~u';

    strrchr($to, '\\') === false or $to = preg_replace('/\\/u', '\\\\', $to);
    $allTo[] = $to;
  }

  return preg_replace($allFrom, $allTo, $str);
}

function ExtOf($file) {
  return preg_match('~(^|[^\\/])(\.\w{1,7})$~', $file, $matches) ? $matches[2] : '';
}

// $newExt: including leading dot.
function ChangeStrExt($file, $newExt) {
  $ext = ExtOf($file);
  $ext === '' or $file = substr($file, 0, -1 * strlen($ext));
  return $file.$newExt;
}

function IsRelativePath($path) {
  return $path === '' or (strpbrk($path[0], '\\/') === false and strpos($path, ':') === false);
}

// $baseDir defaults to BConfig::$enginePath.
function ToAbsolutePath($path, $baseDir = null) {
  if (IsRelativePath($path)) {
    $baseDir or $baseDir = BConfig::$enginePath;
    $path = rtrim($baseDir, '\\/').'/'.ltrim($path, '\\/');
  }

  return $path;
}

// null $...URL default to BConfig::$siteHome.
function ToAbsoluteURL($url, $currentURL = null, $rootURL = null) {
  $url = ltrim($url, '\\/');

  if (IsRelativePath($url)) {
    if (!IsValidEmail($url)) {
      $currentURL or $currentURL = BConfig::$siteHome;
      $url = rtrim($currentURL, '\\/')."/$url";
    }
  } elseif (strpos(substr($url, 0, 15), '://') === false) {
    $rootURL or $rootURL = BConfig::$siteHome;
    $url = rtrim($rootURL, '\\/')."/$url";
  }

  return $url;
}

// $code: 301 ('permanent'), 302 ('temp').
function RedirectTo($url, $code = 302, $clearOutput = true) {
  static $strToCode = array('permanent' => 301, 'temp' => 302);

  if ($code != 301 and $code != 302) {
    $code = $strToCode[$code];
    if (!$code) {
      throw new BException('RedirectTo() received wrong $code.', '$code = '.$code);
    }
  }

  switch ($code) {
  case 301:
    Header('HTTP/1.0 301 Moved Permanently');
    $how = 'permanently';
    break;
  }

    $how = isset($how) ? " $how" : '';

  header('Location: '.$url);
  header('Content-Type: text/html; charset=utf-8');

  if ($clearOutput) {
    while (ob_get_level()) { ob_end_clean(); }
  }
  echo "You have been$how redirected to <a href=\"$url\">".htmlspecialchars($url).'</a>.';

  exit;
}

function EnsureDirExists($dir) {
  is_dir($dir) or mkdir($dir, 0770, true);
  if (!is_dir($dir)) { throw new BException("Cannot create directory $dir."); }
}

  function MkDirOf($file) { EnsureDirExists( dirname($file) ); }

function RemoveEmptyDirsAbove($path) {
  $paths = explode('/', strtr($path, '\\', '/'));
  while (@rmdir( join('/', $paths) )) { array_pop($paths); }
}

function htmlspecialchars8($str, $flags = ENT_COMPAT, $doubleEncode = true) {
  return htmlspecialchars($str, $flags, 'UTF-8', $doubleEncode);
}

function FindImage($baseName, $imageExts = null) {
  if (!is_dir(dirname($baseName))) { return; }
  if (is_file($baseName)) { return $baseName; }

  if (!is_array($imageExts)) {
    $imageExts = array('.gif' => 1, '.png' => 1, '.jpg' => 1, '.jpeg' => 1, '.bmp' => 1);
  }

  // note using glob() because will process "[abc]", "{a,b}" and other patterns which can
  // are valid in file names (like "[11.04.30] My post.wiki").
  $dir = opendir(dirname($baseName));
  $base = basename($baseName).'.';

    while ((($file = readdir($dir)) !== false) and $file !== null) {
      if (strpos($file, $base) === 0 and
         isset($imageExts[ strtolower(ExtOf($file)) ])) {
        break;
      }
    }

  closedir($dir);
  return is_string($file) ? dirname($baseName)."/$file" : null;
}

function FindImagesIn($path, $imageExts = null) {
  if (!is_array($imageExts)) {
    $imageExts = array('.gif' => 1, '.png' => 1, '.jpg' => 1, '.jpeg' => 1, '.bmp' => 1);
  }

  $path = rtrim($path, '\\/');
  $files = scandir($path);

    foreach ($files as &$file) {
      $file = "$path/$file";
      if (!isset( $imageExts[ strtolower(ExtOf($file)) ] ) or !is_file($file)) {
        $file = null;
      }
    }

  return array_values( array_filter($files) );
}

function ImageToDataURL($file) {
  return 'data:image/png;base64,'.base64_encode( file_get_contents($file) );
}

function IsValidEmail($email) {
  return strrchr($email, '@') !== false and
         preg_match('/^[a-z0-9]([a-z0-9\-_\.]*[a-z0-9])?@[a-z0-9\-\.]+\.[a-z]{2,8}$/iu', trim($email)) ;
}

function MatchWildcardIP($wildcard, $ip) {
  $ip = long2ip(ip2long($ip));

  if (strpos($wildcard, '*') === false) {
    return long2ip(ip2long($wildcard)) === $ip;
  } else {
    return MatchWildcard($wildcard, $ip);
  }
}

  function MatchWildcard($wildcard, $str, $caseSensitive = true) {
    $caseSensitive = $caseSensitive ? 0 : FNM_CASEFOLD;
    return fnmatch($wildcard, $str, $caseSensitive | FNM_NOESCAPE | FNM_PATHNAME | FNM_PERIOD);
  }

function IsAtDebug() {
  return (($_SERVER['REMOTE_ADDR'] === '127.0.0.1' or isset( $_SERVER['argc'] )) and
          ini_get('error_reporting') !== 0 and ini_get('display_errors'));
}

function NotifyOf($event, $title, array &$vars) {
  BEvent::Fire('notify', array(&$event, &$title, &$vars));
}

function IsRobotAgent($str = null) {
  $str = trim( $str ? $str : $_SERVER['HTTP_USER_AGENT'] );
  return $str ? BEvent::FireResult('bool', 'is robot agent', $str) : false;
}

function ShortenInlineDoc(UWikiDocument $doc, array $options = array()) {
  return BEvent::Fire('shorten inline doc', array(&$doc, &$options));
}

function ShortenInlineText($str, array $options = array()) {
  return BEvent::Fire('shorten inline text', array(&$str, &$options));
}

function SingleInstanceOf($class) {
  static $inst = array();
  is_object($class) and $class = get_type($class);
  isset($inst[$class]) or $inst[$class] = new $class;
  return $inst[$class];
}

function LoadKeyValuesFrom($file, $separator = '\s+') {
  return is_file($file) ? ParseKeyValues(file_get_contents($file), $separator) : array();
}

  function ParseKeyValues($str, $separator = '\s+') {
    $result = array();

      foreach (explode("\n", $str) as $line) {
        if ($line !== '' and strpbrk($line[0], '#;') === false and ($line = trim($line)) !== '') {
          @list($key, $value) = preg_split("/$separator/u", $line, 2);
          isset($value) and $result[ trim($key) ] = stripcslashes( ltrim($value) );
        }
      }

    return $result;
  }

function LoadKeyValuesExt($file, $separator = '=') {
  return is_file($file) ? ParseKeyValuesExt(file_get_contents($file), $separator) : array();
}

  function ParseKeyValuesExt($str, $separator = '=') {
    $result = array();

      $block = null;
      $value = '';

      foreach (explode("\n", $str) as $line) {
        if ($block === null) {
          $line = trim($line);

          if ($line !== '' and strpbrk($line[0], '#;') === false) {
            @list($key, $value) = preg_split("/$separator/u", $line, 2);

              $key = rtrim($key);
              $value = ltrim($value);

            if ($value === '{') {
              $block = $key;
              $value = '';
            } elseif (isset($value)) {
              $result[$key] = stripcslashes($value);
            }
          }
        } elseif ($line === '}') {
          $result[$block] = substr($value, 0, -1);
          $block = null;
        } else {
          $value .= rtrim($line)."\n";
        }
      }

    return $result;
  }

// taken from UWikiFilePager.
function ExpandLeaveLinks($path, $cwd = null) {
  if (!is_string($path)) { return; }

    $cwd === null and $cwd = getcwd();
    $cwd = rtrim($cwd, '\\/');

  $firstIsSlash = strpbrk(@$path[0], '\\/');
  if ($path === '' or (!$firstIsSlash and @$path[1] !== ':')) {
    $path = "$cwd/$path";
  } elseif ($firstIsSlash and @$cwd[1] === ':') {
    // when a drive is specified in CWD root \ or /) refers to its root.
    $path = substr($cwd, 0, 2).$path;
  }

  $path = strtr($path, '\\', '/');

    if ($path !== '' and ($path[0] === '/' or @$path[1] === ':')) {
      list($prefix, $path) = explode('/', $path, 2);
      $prefix .= '/';
    } else {
      $prefix = '';
    }

  $expanded = array();
  foreach (explode('/', $path) as $dir) {
    if ($dir === '..') {
      array_pop($expanded);
    } elseif ($dir !== '' and $dir !== '.') {
      $expanded[] = $dir;
    }
  }

  return $prefix.join('/', $expanded);
}

// used when supplying vars for page template; returns vars for page control
// (currentPage and pageURL).
function GetPageVars($urlExtra = '') {
  $vars = array('currentPage' => @$_REQUEST['page']);

    @list($url, $qs) = explode('?', $_SERVER['REQUEST_URI'], 2);
    trim($qs) === '' or $qs .= '&';
    $qs = str_replace("page=$vars[currentPage]&", '', $qs);
    $vars['pageURL'] = str_replace('$', '$$', "$url?$qs").'page=$'.$urlExtra;

  return $vars;
}

// $file can be array($file, $imageType); if type omitted will be determined from file ext.
// $maxSize can be array($maxWidth, $maxHeight); otherwise both are set to $maxSize.
function ScaleImage($file, $maxSize, $saveTo = null, $appendExt = false) {
  if (is_array($file)) {
    list($file, $imageType) = $file;
  } else {
    $imageType = null;
  }

  list($width, $height) = getimagesize($file);

    if (is_array($maxSize)) {
      list($maxWidth, $maxHeight) = $maxSize;
    } else {
      $maxWidth = $maxHeight = $maxSize;
    }

    $maxWidth or $maxWidth = $width;
    $maxHeight or $maxHeight = $height;

  if (!function_exists('gd_info')) {
    throw new BException("Cannot scale image - PHP GD library is not available.");
  }

  $ratio = min($maxWidth / $width, $maxHeight / $height);
  $thumbWidth = $width * $ratio;
  $thumbHeight = $height * $ratio;

  $thumb = imagecreatetruecolor($thumbWidth, $thumbHeight);
  if (!$thumb) {
    throw new BException("Cannot scale image - imagecreatetruecolor has failed.");
  }

  imagealphablending($thumb, false);
  imagesavealpha($thumb, true);

    if (!$imageType) {
      $extPos = strrpos($file, '.');
      if (!$extPos) {
        throw new BException('Cannot scale image - image file has no extension.');
      }

      $imageType = substr($file, $extPos + 1);
    }

      $imageType === 'jpg' and $imageType = 'jpeg';
      $imageType = strtolower($imageType);

    $create = 'imagecreatefrom'.$imageType;
    $original = function_exists($create) ? $create($file) : null;
    if (!$original) {
      throw new BException("Cannot open image to scale (need $create function).");
    }

      if (imagecopyresampled($thumb, $original, 0, 0, 0, 0, $thumbWidth, $thumbHeight, $width, $height)) {
        $output = 'image'.$imageType;
        $appendExt and $saveTo .= ".$imageType";
        if (!$output($thumb, $saveTo)) {
          throw new BException('Cannot save scaled image.');
        }
      } else {
        throw new BException('Cannot scale image - imagecopyresampled() has failed.');
      }

    imagedestroy($original);

  imagedestroy($thumb);
  return $saveTo;
}


/* Functions for converting between notations and short MD5 generation.
 * No license (public domain) but backlink is always welcome :)
 * By Proger_XP. http://proger.i-forge.net/Short_MD5
 */

function MD5_24($str) {
  static $alphabet = '0123456789abcdefghijklmnopqrstuvwxyzABCDE';
  return RawToShortMD5($alphabet, md5($str, true));
}

function MD5File_24($file) {
  static $alphabet = '0123456789abcdefghijklmnopqrstuvwxyzABCDE';
  return RawToShortMD5($alphabet, md5_file($file, true));
}

function MD5_24toRaw($hash24) {
  static $alphabet = '0123456789abcdefghijklmnopqrstuvwxyzABCDE';
  return ShortToRawMD5($alphabet, $hash24);
}

function MD5_24to32($hash24) {
  static $alphabet = '0123456789abcdefghijklmnopqrstuvwxyzABCDE';
  return RawToMD5(ShortToRawMD5($alphabet, $hash24));
}

function RawToShortMD5($alphabet, $raw) {
  $result = '';
  $length = strlen(DecToBase($alphabet, 2147483647));

  foreach (str_split($raw, 4) as $dword) {
    $dword = ord($dword[0]) + ord($dword[1]) * 256 + ord($dword[2]) * 65536 + ord($dword[3]) * 16777216;
    $result .= str_pad(DecToBase($alphabet, $dword), $length, $alphabet[0], STR_PAD_LEFT);
  }

  return $result;
}

  function DecToBase(&$alphabet, $dword) {
    $rem = fmod($dword, strlen($alphabet));
    if ($dword < strlen($alphabet)) {
      return $alphabet[$rem];
    } else {
      return DecToBase($alphabet, ($dword - $rem) / strlen($alphabet)).$alphabet[$rem];
    }
  }

function ShortToRawMD5($alphabet, $short) {
  $result = '';
  $length = strlen(DecToBase($alphabet, 2147483647));

  foreach (str_split($short, $length) as $chunk) {
    $dword = BaseToDec($alphabet, $chunk);
    $result .= chr($dword & 0xFF) . chr($dword >> 8 & 0xFF) . chr($dword >> 16 & 0xFF) . chr($dword >> 24);
  }

  return $result;
}

  function BaseToDec($alphabet, $str) {
    $result = 0;
    $prod = 1;

    for ($i = strlen($str) - 1; $i >= 0; --$i) {
      $weight = strpos($alphabet, $str[$i]);
      if ($weight === false) {
        throw new Exception('BaseToDec failed - encountered a character outside of given alphabet.');
      }

      $result += $weight * $prod;
      $prod *= strlen($alphabet);
    }

    return $result;
  }

function RawToMD5($raw) {
  $result = '';
  foreach (str_split($raw) as $i => $byte) {
    $result .= str_pad(dechex(ord($byte)), 2, '0', STR_PAD_LEFT);
  }
  return $result;
}
