<?php
include_once 'formatted_text.php';

class Upre_Root extends UWikiBaseElement {
  public $isFormatter = true;
  public $isAction = false;
  public $isBlock = true;
  // since browsers display <pre> with preserved whitespace extra newlines and indentation
  // will cause the actual pre's contents look different.
  public $isSingleLineHTML = true;
  public $htmlTag = 'pre';

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);
    $props['str'][] = 'raw';
  }

  function Parse() {
    if ($format = $this->settings->format) {
      $this->isBlock = $format->blockExpected;
      $this->isBlock or $this->htmlTag = 'kbd';
    }

    parent::Parse();
  }

  function SelfToHtmlWith($contents) {
    $contents = self::QuoteHTML($this->raw);
    // $isSingleHtmlTag might be set by child classes (e.g. for <input />).
    $this->isSingleHtmlTag and $this->htmlAttributes['value'] = $contents;
    return parent::SelfToHtmlWith($contents);
  }
}

class UWikiTextFromRaw extends UWikiFormattedText { }

  class Utext_Root extends UWikiTextFromRaw {
    public $htmlTag = 'span';
    public $htmlClasses = array('text');
  }

abstract class UWikiStringMessage extends UWikiFormattedText {
  public $htmlTag = 'em';
  public $htmlClasses = array('string-message');

  public $message, $format, $defaultMessage;

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);

    $props['hash'][] = 'format';
    $props['str'][] = 'message';
    $props['str'][] = 'defaultMessage';
  }

  function SelfToHtmlWIth($contents) {
    $msg = @$this->strings[$this->message];
    self::IsEmptyStr($msg) and $msg = $this->defaultMessage;

      if ($format = ((array) $this->format)) {
        array_unshift($format, $msg);
        $msg = call_user_func_array('sprintf', $format);
      }

    $this->SetSettingsFrom($msg);
    return parent::SelfToHtmlWIth($msg);
  }
}

  abstract class UWikiFormatErrorMessage extends UWikiStringMessage {
    public $htmlClasses = array('format-error');
  }

    class UWikiFormatterError extends UWikiFormatErrorMessage {
      public $message = 'formatter error';
    }

    class UWikiInliningBlocksError extends UWikiFormatErrorMessage {
      public $message = 'inlining blocks only';
    }

    class Unotexistingformat_Root extends UWikiFormatErrorMessage {
      public $message = 'not existing format';
    }
