<?php

abstract class UWikiBaseHighlighter extends UWikiBaseElement {
  /* To be set in children */
  public $langName = '';    // lower-case
  // 1. Don't forget to escape special regexp chars and '~' (pattern delimiter)
  // 2. Since HTML is pre-quoted refer to entities as &lt; ("<"), &amp; ("&"), etc.
  // 2.1. Quotes are not quoted: " = " and ' = '
  // 3. Don't use capturing brackets, use "(?:...)" instead
  public $constructs = array();
  public $keywords = array();
  public $anyCaseKeyword = false;

  public $isFormatter = true;
  public $isAction = false;
  public $htmlTag = 'code';
  public $htmlClasses = array('format', 'format-');

  protected $regexpClasses;

  function __construct() {
    parent::__construct();
    $this->htmlClasses[1] .= $this->langName;
  }

    function Attachments() {
      $result = array('css' => array());

        $css = $this->CSS();
        if ($css) {
          $prefix = ".format-".$this->langName.' ';
          $css = str_replace('$', $prefix, $css);
          $result['css'][ucfirst($this->langName).' highlight'] = trim($css, "\r\n");
        }

      return $result;
    }

  function Parse() {
    if ($format = $this->settings->format) {
      $this->isBlock = $format->blockExpected;
    } else {
      // absense of format chain means it's called directly as a markup, e.g. TryParsing(..., 'scripter')
      $this->isBlock = true;
    }

    $this->isBlock and $this->htmlTag = 'pre';
  }

  function SelfToHtmlWith($html) {
    $html = self::QuoteHTML( str_replace("\r\n", "\n", $this->raw) );

    list($regexp, $classes) = $this->RegExp();
    $this->regexpClasses = $classes;
    $html = preg_replace_callback($regexp, array($this, 'Replace'), $html);

    $prefix = "<span class=\"format-name\">{$this->langName}</span>";
    return parent::SelfToHtmlWith($prefix.$html);
  }

    function Replace($match) {
      foreach ($match as $i => $value) {
        if ($i > 0 and "$value" !== '') {
          $class = $this->regexpClasses[$i - 1];
          return "<span class=\"$class\">$value</span>";
        }
      }

      return 'Unexpected highlighter match!';
    }

  /* The rest below can be overriden */

  function CSS() { }

  protected function RegExp() {
    $pieces = $this->RegExpPieces();
    return array('~'.join('|', array_keys($pieces)).'~um', array_values($pieces));
  }

    protected function RegExpPieces() {
      $result = array();

        foreach ($this->constructs as $class => $tokens) {
          $result += is_int($class) ? $tokens : $this->RegExpPieceFrom($tokens, $class);
        }

        if ($keywords = $this->keywords) {
          $case = $this->anyCaseKeyword ? '(?i)' : '';
          $result['\b('.$case.join('|', $keywords).')\b'] = 'keyword';
        }

      return $result;
    }

      protected function RegExpPieceFrom(array $tokens, $class) {
        $result = array();

          foreach ($tokens as $token) {
            @list($op, $ed, $multiline) = (array) $token;

            if ($multiline) {
              $result["({$op}[\s\S]*?$ed)"] = "$class block";
            } else {
              $result["($op.*?$ed)"] = "$class inline";
            }
          }

        return $result;
      }
}
