<?php
/*
  This formatter simply takes whatever is passed to it and creates a table with 2 columns:
  one containing orignal unformatted text and another with a string formatted using Umirror_Root's
  default formatter. You can use nesting such as %%(mirror, css) to render source in different formats.

  You can do as crazy things as this (although they might make no sense):
  %%(Mirror)
  %%(Mirror)
  %%(Wacko)
  * //format me already//!
  ~~%%
  ~%%
  %%
*/

class Umirror_Root extends UWikiBaseElement {
  public $isFormatter = true;
  public $isAction = false;

  public $isBlock = true;
  public $htmlTag = 'table';
  public $htmlClasses = array('mirror');

  function Parse() {
    $source = $this->NewElement('Umirror_Source');
    $source->SetRaw($this->raw);

    $result = $this->NewElement('Umirror_Result');

    if ($format = $this->settings->format) {
      $format->root = $result;
      $format->IsEmpty() and $format->AddFormat( $this->DefaultStyle() );
    } elseif ($doc = UWikiDocument::TryParsing($this->raw, $this->settings, $this->DefaultStyle())) {
      $result->children[] = $doc->root;
    } else {
      $result = $source;
      $result->htmlClasses[0] = 'result';
    }

    $this->children = array($source, $result);
  }

  function SelfToHtmlWith($contents) {
    return parent::SelfToHtmlWith("<tr>\n$contents\n</tr>");
  }
}

  class Umirror_Result extends UWikiBaseElement {
    public $isBlock = true;
    public $htmlTag = 'td';
    public $htmlClasses = array('result');
  }

    class Umirror_Source extends Umirror_Result {
      public $htmlClasses = array('source');

      function SetupSerialize(array &$props) {
        parent::SetupSerialize($props);
        $props['str'][] = 'raw';
      }

      function SelfToHtmlWith($contents) {
        $html = '<pre>'.self::QuoteHTML($this->raw).'</pre>';
        return parent::SelfToHtmlWith($html);
      }
    }
