<?php
/*
  {{Title: Document //title//}}         - colonis optional
  {{Title  "Title with, comma=and eq. sign"}}

  %%(title)
    Document //title// with any, any = chars.
  %%

    In any case you can specify a formatter: {{Title "title"; java}}, %%(title; delphi)

  Without arguments {{Title}} will output document title.
*/

class Utitle_Root extends UWikiBaseAction {
  public $isFormatter = true; 
  public $htmlTag = 'span';
  public $htmlClasses = array('doc-title');

  public $origDoc, $outputSelf = false;

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);

    $props['document'][] = 'origDoc';
    $props['bool'][] = 'outputSelf';
  }

  function Execute($format, $params) {
    $format->appendMe = true;

      if (self::IsEmptyStr($format->raw)) {
        $params = array_keys($params);
        $format->raw = &$params[0];
      }

    if (!self::IsEmptyStr($format->raw)) {
      $this->isBlock = false;   // title must be inline.

      $format->root = $this;
      $format->IsEmpty() and $format->AddFormat( $this->DefaultStyle() );
      $format->HookAfterNextFormat($this, 'SetTitle', $format->blockExpected);
    } else {
      $this->outputSelf = true;
      $this->origDoc = $format->origDoc;
    }
  }

    function SetTitle($calledFormat, $format, $blockExpected) {
      $inline = $calledFormat['doc']->root->FindInline();
      if ($inline === null and !$calledFormat['doc']->root->isBlock) {
        $inline = $this;
      }

      if (!$inline) {
        $this->children = array( $this->NewElement('Utitle_OnlyBlockChildren') );
        $this->outputSelf = true;
      } else {
        $this->children = &$inline->children;
        $format->origDoc->title = $this;
      }

      $this->isBlock = $blockExpected;
    }

  function SelfToHtmlWith($contents) {
    if ($this->outputSelf) {
      if ($this->origDoc) {
        return parent::SelfToHtmlWith($this->origDoc->HtmlTitle());
      } else {
        return parent::SelfToHtmlWith($contents);
      }
    }
  }
}

  class Utitle_OnlyBlockChildren extends UWikiFormatErrorMessage {
    public $message = '{{title: only blocks present';
    public $defaultMessage = 'Cannot set document title via {{Title}} because string passed to it formatted into only block elements - and doc title must be inline.';
  }

// we have to use a hook to set 'shifted' mode before parsing starts because Utitle_Root
// won't be called unless tree is built (just not parsed yet) - and Uwacko_Heading accesses
// $headingMode while it is being built (FindTokenCallback).
UWikiDocument::$beforeParsingHooks[] = 'SetShiftedHeadersIfTitleSpecified';

  function SetShiftedHeadersIfTitleSpecified($doc) {
    if ($doc->settings->headingMode === 'normal' and $doc->settings->markupName === 'wacko') {
      $names = array('title');
      foreach ($doc->settings->styleAliases as $alias => $real) {
        $real === 'title' and $names[] = $alias;
      }
      $names = '('. join('|', $names) .')';

      $regExp = '~(?<!\~)\{\{'.$names.' +.+?}}|(^|\n)%%\('.$names.'(;.*)?\)\r?\n~ui';
      if (preg_match($regExp, $doc->GetSource())) {
        $doc->settings->headingMode = 'shifted';
      }
    }
  }
