<?php
/*
  This extension loads WackoWiki highlighters as normal UverseWiki markups (that only
  operate in block form, though). For it to work set $settings->wackoWikiHighlDir.
*/

UWikiDocument::$setSourceHooks[] = array('UWackoWikiBaseHighlightRoot', 'LoadFor');

class UWackoWikiBaseHighlightRoot extends UWikiBaseElement {
  public $isFormatter = true;
  public $isAction = false;
  public $isBlock = true;
  public $htmlTag = 'div';
  public $htmlClasses = array('wackowiki', 'format');

  public $html;

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);
    $props['str'][] = 'html';
  }

  function Parse() {
    $language = $this->MarkupName();
    $this->htmlClasses[] = 'format-'.$language;

    $highl = new UWackoWikiHighlight($language, $this->settings);

    $options = $this->settings->format ? $this->settings->format->current['params'] : array();
    $this->html = $highl->Highlight($this->raw, $options);
  }

  function SelfToHtmlWith($contents) {
    $prefix = "<span class=\"format-name\">{$this->MarkupName()}</span>\n";
    return parent::SelfToHtmlWith($prefix.$this->html);
  }

  static function DefineMarkups(array $list) {
    foreach ($list as $markup) {
      if (!UWikiDocument::MarkupExists($markup)) {
        eval("class U{$markup}_Root extends UWackoWikiBaseHighlightRoot { }");
      }
    }
  }

  static function LoadFor(&$source, UWikiDocument $doc) {
    UWackoWikiBaseHighlightRoot::DefineMarkups( UWackoWikiHighlight::ListIn($doc->settings) );
  }
}

// Support layer for highlighters coming with WackoWiki.
class UWackoWikiHighlight {
  public $highl, $settings;

  static function Exists($highl, $settings) {
    return is_file( self::FileOf($highl, $settings) );
  }

    static function FileOf($highl, $settings) {
      $root = rtrim($settings->wackoWikiHighlDir, '\\/');
      if ($root !== '' and preg_match('/^\w+$/', $highl)) { return "$root/$highl.php"; }
    }

    static function ListIn($settings) {
      $result = array();

        $root = rtrim($settings->wackoWikiHighlDir, '\\/');
        foreach (glob("$root/*.php", GLOB_NOSORT) as $file) {
          $markup = basename($file, '.php');
          if (self::FileOf($markup, $settings)) {
            $result[] = $markup;
          }
        }

      return $result;
    }

  static function TryHighl(&$text, $settings, $highl, $options = array()) {
    if (self::Exists($highl, $settings)) {
      try {
        $highlObj = new self($highl, $settings);
        return $highlObj->Highlight($text, $options);
      } catch (Exception $e) {
      }
    }
  }

  function __construct($highl, $settings) {
    $this->highl = $highl;
    $this->settings = $settings;
  }

  function Highlight($text, $options = array()) {
    ob_start();
      include self::FileOf($this->highl, $this->settings);
    return ob_get_clean();
  }


  /* Simulation of WackoWiki object: */

  public $method = 'html';
  public $config = array();
  public $_formatter_noautolinks = false;

  function format($text, $highl, $options) {
    return self::TryHighl($text, $this->settings, basename($highl), $options);
  }

  // $class is e.g. 'javahighlighter'. Additionally, there's a typo in the Pascal highlighter and
  // it calls 'delphihightlighter' (note the "T").
  function use_class($class, $path) {
    $class = basename($class, 'highlighter');
    $class = basename($class, 'hightlighter');

    $mainHighlFile = self::FileOf($class, $this->settings);
    $mainHighlFile = dirname($mainHighlFile).'/'.basename($mainHighlFile, 'php').'class.php';
    include_once $mainHighlFile;
  }
}
