<?php
// There was a bug with tree pos collisions that generated anchors only for last list item.

  $src = '
== Заглавие ==
    Абзац 1.
=== Секция ==
Абзац 2.
  1. Пункт 1.
  1. Пункт 2.
  3. Пункт 3.
  Абзац 3.
';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->settings->anchorize['wacko_ListItem'] = true;
  $doc->settings->autoAnchorContractions['wacko_ListItem'] = 'l';
  $doc->settings->autoAnchorContractions['wacko_Paragraph'] = 'para';
  $doc->LoadMarkup('wacko');

  $doc->Parse();
  $html = $doc->ToHTML();

$expectedHTML = '
<h1>
Заглавие<a name="заглавие" href="#заглавие" title="#заглавие" class="anchor">¶</a>
</h1>
<p class="indent-2 default">
Абзац 1.
<a name="para_1-1" href="#para_1-1" title="#para_1-1" class="anchor">¶</a>
</p>
<h2>
Секция<a name="секция" href="#секция" title="#секция" class="anchor">¶</a>
</h2>
<p class="default">
Абзац 2.
<a name="para_1.1-1" href="#para_1.1-1" title="#para_1.1-1" class="anchor">¶</a>
</p>
<ol><li class="decimal" value="1">Пункт 1.<a name="l_1.1-1" href="#l_1.1-1" title="#l_1.1-1" class="anchor">¶</a></li><li class="decimal">Пункт 2.<a name="l_1.1-2" href="#l_1.1-2" title="#l_1.1-2" class="anchor">¶</a></li><li class="decimal" value="3">Пункт 3.<a name="l_1.1-3" href="#l_1.1-3" title="#l_1.1-3" class="anchor">¶</a></li></ol>
<p class="indent-1 default">
Абзац 3.
<a name="para_1.1-2" href="#para_1.1-2" title="#para_1.1-2" class="anchor">¶</a>
</p>
';

  TestEquality( preg_replace('/(\r?\n)+/u', "\n", trim($html)), trim($expectedHTML) );
