<?php

$tests = array(
  'cur/dir' => array(
    'c:\file.ext' => 'c:/file.ext', '\\file.ext' => '/file.ext',
    'file.ext' => 'cur/dir/file.ext', '../file.ext' => 'cur/file.ext',
    '../../../../file.ext' => 'file.ext', '' => 'cur/dir', '.' => 'cur/dir',
    '..' => 'cur', 'a//b\\c' => 'cur/dir/a/b/c', '/../file.ext' => '/file.ext',
    '/' => '/', 'c:/' => 'c:/', 'c:\\' => 'c:/'
  ),
  '/cur/dir' => array(
    'c:\file.ext' => 'c:/file.ext', '\\file.ext' => '/file.ext',
    'file.ext' => '/cur/dir/file.ext', '../file.ext' => '/cur/file.ext',
    '../../../../file.ext' => '/file.ext', '' => '/cur/dir', '.' => '/cur/dir',
    '..' => '/cur', 'a//b\\c' => '/cur/dir/a/b/c', '/../file.ext' => '/file.ext',
    '/' => '/', 'c:/' => 'c:/', 'c:\\' => 'c:/'
  ),
  'c:/' => array(
    'c:\file.ext' => 'c:/file.ext', '\\file.ext' => 'c:/file.ext',
    'file.ext' => 'c:/file.ext', '../file.ext' => 'c:/file.ext',
    '../../../../file.ext' => 'c:/file.ext', '' => 'c:/', '.' => 'c:/',
    '..' => 'c:/', 'a//b\\c' => 'c:/a/b/c', '/../file.ext' => 'c:/file.ext',
    '/' => 'c:/', 'c:/' => 'c:/', 'c:\\' => 'c:/'
  )
);

foreach (array(null, false, 0, 1.5, array()) as $wrongType) {
  TestThat( UWikiFilePager::Expand($wrongType) === null );
}

foreach ($tests as $cwd => $paths) {
  foreach ($paths as $file => $must) {
    TestEquality( UWikiFilePager::Expand($file, $cwd), $must );
  }
}
