<?php

  self::$loadedHandlers[$markup]['block'][] = array('(?<=\r\n|\n) \s* %% (?: \(.+\) )? (?:\r?\n)+', 'Uwacko_BlockFormat', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback | Uwacko_NoTokensInside);

  self::$loadedHandlers[$markup]['inline'][] = array('%%', 'Uwacko_InlineFormat', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback | Uwacko_NoTokensInside);

  self::$loadedHandlers[$markup]['block'][] = array('(?<=\r\n|\n) \s* \{\{ .+ \}\} (?:\r?\n)+', 'Uwacko_BlockAction', Uwacko_SingleTag | Uwacko_Callback);

  self::$loadedHandlers[$markup]['inline'][] = array('\{\{ (?!}})', 'Uwacko_InlineAction', Uwacko_StartTag | Uwacko_NoTokensInside);
  self::$loadedHandlers[$markup]['inline'][] = array('}}', 'Uwacko_InlineAction', Uwacko_EndTag);

class Uwacko_BlockFormat extends Uwacko_Base {
  public $kind = 'format';
  public $isBlock = true;

  static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags) {
    // No style will be extracted from text consisting only of "(brackets)" so we append any text here
    // since we don't know the ending for this tag and thus its real contents.
    $tempToken = trim($token);
    if ($format = $doc->style->ExtractFormatFrom($tempToken, 2)) {
      $flags &= ~Uwacko_EndTag;
      return array($format);
    } elseif (isset( $tempToken[3] )) {  // %%.<something>
      // %% must be surrounded by \n and might have formatters but they must have valid syntax. Here it's not the case.
      return Uwacko_SkipThisToken;
    }
  }

  function SetSettingsFrom(&$raw) {
    $raw = $this->UnindentBlockIfNeeds($raw);
    $raw = $this->Unescape( trim($raw, "\r\n") );
    $this->SetupFormats($this->callbackResult[0], $raw);
  }

    function Unescape($raw) {
        $t = Uwacko_TildeToken;
      return preg_replace('/(?<=\r\n|\n|^)(\s*)'.$t.'('.$t.'*%%)(\r?\n|$)/u', '\1\2\3', $raw);
    }
}

abstract class Uwacko_BaseInlineFormat extends Uwacko_Base {
  public $kind = 'format';
  public $removeEscInside = true;

  static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags) {
    return Uwacko_TwoChars::FindTokenCallback($doc, $raw, $positions, $stack, $token, $pos, $flags);
  }

  function SetSettingsFrom(&$raw) {
    $contents = "($raw)";
    $handlers = $this->style->ExtractFormatFrom($contents);

    if ($handlers) {
      $contents = '';
      $this->SetupFormats($handlers, $contents);
    } else {
      $this->children[] = $this->NewElement('Uwacko_WrongActionSyntax');
    }
  }
}

  class Uwacko_BlockAction extends Uwacko_BaseInlineFormat {
    public $isBlock = true;

    static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags) {
        $t = Uwacko_TildeToken;
        $contents = substr(trim($token), 2, -2);

      if (self::DeleteIfUnevenTail($t, $contents) or  // {{action ... ~}} - end tag is escaped
          preg_match("/[^$t]($t$t)*}}/mu", $contents, $matches)) {   // unescaped }} inside, ambiguous
        // ambiguity: {{a}} b}} - it's not 1 block action but 1 inline action + text "b}}'.
        return Uwacko_SkipThisToken;
      } else {
        return array( strtr($contents, array($t.$t => $t, '~}}' => '}}')) );
      }
    }

    function SetSettingsFrom(&$raw) {
      parent::SetSettingsFrom( $this->callbackResult[0] );
    }
  }

  class Uwacko_InlineAction extends Uwacko_BaseInlineFormat { }

    class Uwacko_InlineFormat extends Uwacko_InlineAction {
      function SetSettingsFrom(&$raw) {
        $tildeCount = $i = 0;
        while ($raw[$i++] === Uwacko_TildeToken) { ++$tildeCount; }

        $raw = trim($raw);
        $rawNoStyle = $raw;

        if ($tildeCount === 0) {
          $handlers = $this->style->ExtractFormatFrom($raw);
        } elseif ($raw[$tildeCount] === '(') {
          $raw = substr($raw, 1);
        }

        $this->SetupFormats($handlers, $raw);
      }
    }

class Uwacko_WrongActionSyntax extends UWikiFormatErrorMessage {
  public $message = '{{: wrong syntax';
}
