<?php
include_once 'block.php';

  self::$loadedHandlers[$markup]['block'][] = array('(?<=\r\n|\n) ==+ .+ ==+ (?:\r?\n)+', 'Uwacko_Heading', Uwacko_SingleTag | Uwacko_Callback);

  self::$loadedHandlers[$markup]['inline'][] = array(Uwacko_TildeToken, Uwacko_OneTokenEscape, Uwacko_DoesNotDivide | Uwacko_DeleteToken | Uwacko_EscTagAfterSelf);
  self::$loadedHandlers[$markup]['inline'][] = array(Uwacko_SubstrEscToken, Uwacko_SubstrEscape, Uwacko_DoesNotDivide| Uwacko_DeleteToken | Uwacko_StartTag | Uwacko_EndTag | Uwacko_NoTokensInside);

  self::$loadedHandlers[$markup]['inline'][] = array('(?<='.UWikiLeftWordBoundary.')"', 'Uwacko_Citation', Uwacko_StartTag | Uwacko_Callback);
  self::$loadedHandlers[$markup]['inline'][] = array('"', 'Uwacko_Citation', Uwacko_EndTag);

  self::$loadedHandlers[$markup]['inline'][] = array('\*\*', 'Uwacko_Bold', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback);
  self::$loadedHandlers[$markup]['inline'][] = array('--', 'Uwacko_Strike', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback);
  self::$loadedHandlers[$markup]['inline'][] = array('__', 'Uwacko_Underline', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback);
  self::$loadedHandlers[$markup]['inline'][] = array('\/\/', 'Uwacko_Italic', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback);
  self::$loadedHandlers[$markup]['inline'][] = array('\+\+', 'Uwacko_Small', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback);
  self::$loadedHandlers[$markup]['inline'][] = array('\^\^', 'Uwacko_Superscript', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback);
  self::$loadedHandlers[$markup]['inline'][] = array('\#\#', 'Uwacko_Monotype', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback);

  self::$loadedHandlers[$markup]['inline'][] = array('!!', 'Uwacko_Highlight', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback);
  self::$loadedHandlers[$markup]['inline'][] = array('\?\?', 'Uwacko_Dubious', Uwacko_StartTag | Uwacko_EndTag | Uwacko_Callback);

abstract class Uwacko_InlineElement extends Uwacko_Tokenizer {
  public $handlerGroup = 'inline';
  public $defaultTokenClass = 'Uwacko_Text';
}

class Uwacko_Heading extends Uwacko_InlineElement {
  static $maxLevel = 6;

  public $kind = 'heading';
  public $isBlock = true;

  public $level;
  // if true anchor name shouldn't be changed even when similar-looking names are
  // given out (see UWikiAnchorList->UniqueNameFrom().
  public $retainAnchor = false;

  static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags) {
      $tempToken = trim($token);

    $leftLevel = self::CountLeftCharIn($tempToken, '=');
    $rightLevel = strlen($tempToken) - strlen( rtrim($tempToken, '=') );
    $shiftedMode = (int) ($doc->settings->headingMode !== 'normal');

    if ($leftLevel <= (self::$maxLevel - $shiftedMode + 1) and $leftLevel >= $rightLevel) {
      $text = trim( substr($tempToken, $leftLevel, -1 * $rightLevel) );
      if ($text !== '') {
        if ($shiftedMode) {
          $mode = intval( substr($doc->settings->headingMode, -1) );
          $leftLevel += $mode > 1 ? $mode - 1 : 1;
        }

        return array('level' => $leftLevel - 1, 'text' => $text);
      }
    }

    return Uwacko_SkipThisToken;
  }

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);

    $props['int'][] = 'level';
    $props['bool'][] = 'retainAnchor';
  }

  function HasBlockChildren() { return false; }

  function Parse() {
    $notAnchorized = !$this->anchor;
    if ($notAnchorized) {
      $this->settings->handlers->AddTo('linkOnToken', array($this, 'OnLinkToken'));
      $this->settings->handlers->AddTo('linkOnParse', array($this, 'AddExplicitAnchor'));
    }

    $result = parent::Parse();

    if ($notAnchorized) {
      $this->settings->handlers->RemoveOrThrow('linkOnToken', array($this, 'OnLinkToken'));
      $this->settings->handlers->RemoveOrThrow('linkOnParse', array($this, 'AddExplicitAnchor'));
    }

    return $result;
  }

    function OnLinkToken(&$settings) {
      $this->anchor or $settings['inlineAnchors'] = true;
    }

    function AddExplicitAnchor(&$info, $link, &$replaceWith) {
      if (!$this->anchor and $replaceWith instanceof $this->anchorClass) {
        $this->anchor = $replaceWith;
        $this->anchor->PointTo($this);
        $this->retainAnchor = true;

        $replaceWith = array();
        return true;
      }
    }

    function SetSettingsFrom(&$raw) {
      $this->level = $this->callbackResult['level'];
      if ($this->level === 2 and $this->settings->headingMode === 'extended' and
          $this->doc->GetTitle() === null) {
        --$this->level;
      }

      $this->SetRaw( $this->callbackResult['text'] );
    }

  function SelfToHtmlWith($contents) {
    if (!$this->settings->hideDocTitle or $this->doc->GetTitle() !== $this) {
      $this->htmlTag or $this->htmlTag = 'h'.min($this->level, self::$maxLevel);
      return parent::SelfToHtmlWith($contents);
    }
  }
}

class Uwacko_Citation extends Uwacko_InlineElement {
  // <q> would suit better (it's expected to be nested, there's a CSS prop for quote
  // styles, etc.) but most browsers I know of don't copy things that use :before/:after
  // pseudoclasses properly - i.e. they only copy the contents which is inconvenient at best.
  public $htmlTag = 'span';
  public $htmlClasses = array('quotes');

  static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags) {
    // resolving ambiguity with ellipsis: ..."ish!", "Ah..." -> citations.
    if (!empty($stack) and $stack[0][2] === $flags and $stack[0][0] === __CLASS__
        and substr($raw, $pos - 3, 3) === '...') {
      $flags |= Uwacko_EndTag;
    }
  }

  function AllToHTML() {
    $level = &$this->settings->citationLevel;
    ++$level;
    $this->htmlClasses[] = 'quotes-'.min(count($this->settings->quotes) - 1, $level);

    $html = parent::AllToHTML();
    --$level;
    return $html;
  }

    function SelfToHtmlWith($contents) {
      $quotes = $this->settings->quotes;
      $level = min(count($quotes) - 1, $this->settings->citationLevel);
      return parent::SelfToHtmlWith( $quotes[$level][0]. $contents .$quotes[$level][1] );
    }
}

abstract class Uwacko_TwoChars extends Uwacko_InlineElement {
  static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags) {
      $hasLeftSpace = self::IsWhiteSpace( $raw[$pos - 1] );
      $hasRightSpace = self::IsWhiteSpace( $raw[$pos + 2] );

    if ($hasLeftSpace and $hasRightSpace) { return Uwacko_SkipThisToken; }
  }
}

  class Uwacko_Bold extends Uwacko_TwoChars {
    public $htmlTag = 'strong';
  }
  class Uwacko_Strike extends Uwacko_TwoChars {
    public $htmlTag = 'del';
  }
  class Uwacko_Underline extends Uwacko_TwoChars {
    // <u> isn't HTML5-compliant and <ins> is displayed underlined in IE*/FF/Opera/Chrome.
    public $htmlTag = 'ins';
  }
  class Uwacko_Italic extends Uwacko_TwoChars {
    public $htmlTag = 'em';
  }
  class Uwacko_Small extends Uwacko_TwoChars {
    public $htmlTag = 'small';
  }
  class Uwacko_Superscript extends Uwacko_TwoChars {
    public $htmlTag = 'sup';
  }
  class Uwacko_Monotype extends Uwacko_TwoChars {
    public $htmlTag = 'kbd';
  }

    class Uwacko_Highlight extends Uwacko_TwoChars {
      public $htmlTag = 'span';
      public $html5Tag = 'mark';
      public $htmlClasses = array('highlight');

      public $userStyles = array();

      function SetupSerialize(array &$props) {
        parent::SetupSerialize($props);
        $props['list'][] = 'userStyles';
      }

      static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags) {
        if ($raw[$pos + 2] === '(') {
          $flags = $flags & ~Uwacko_EndTag;
        }

        return parent::FindTokenCallback($doc, $raw, $positions, $stack, $token, $pos, $flags);
      }

      function SetSettingsFrom(&$raw) {
        if (isset($raw[2]) and $raw[0] === Uwacko_TildeToken
            and $raw[1] !== Uwacko_TildeToken) {
          $rawWithouStyles = $raw;
          $styles = $this->style->ExtractMultipleFrom($rawWithouStyles, 1);

          if ($styles) {
            $raw = substr($raw, 1);
            $styles = array();
          }
        } else {
          $styles = $this->style->ExtractMultipleFrom($raw);
        }

        $styles or $styles[] = null;
        foreach ($styles as $style) {
          $this->htmlClasses[] = $this->userStyles[] = $this->RealStyleBy($style);
        }
      }
    }

      class Uwacko_Dubious extends Uwacko_Highlight {
        public $htmlTag = 'var';
        public $htmlClasses = array('dubious');

        function SetSettingsFrom(&$raw) {
          if (!$this->settings->dubiousAsComments) {
            parent::SetSettingsFrom($raw);
          } else {
            $this->htmlClasses[] = 'comment';

            if (!$this->settings->showComments) {
              $raw = null;
              $this->htmlTag = null;
            }
          }
        }
      }
