<?php

  self::$loadedHandlers[$markup]['inline'][] = array('&&[a-zA-Z0-9]+;', 'Uwacko_Entity', Uwacko_SingleTag | Uwacko_Callback);

  $horizRule = array('(?<=\r\n|\n) \s* (?: ---+|===+|\*\*\*+|~~~+) (?:\r?\n)+', 'Uwacko_HorizRule', Uwacko_SingleTag);
  // put it before tilde (~).
  array_unshift(self::$loadedHandlers[$markup]['block'], $horizRule);

  $forcedBreak = array(Uwacko_Base::PregQuoteX(Uwacko_ForcedLineBreakToken).'+', 'Uwacko_ForcedLineBreak', Uwacko_SingleTag);
  // put it at the beginning so --- will be matched prior to --strike--.
  array_unshift(self::$loadedHandlers[$markup]['inline'], $forcedBreak);

class Uwacko_Anchor extends UWikiAnchorElement {
  function SetSettingsFrom(&$raw) {  // when invoked as markup handler.
    $this->SetExactAnchorName( mb_substr(trim($this->startToken), 3, -2) );
    $this->isBlock = true;
  }
}

class Uwacko_Entity extends Uwacko_Base {
  public $entity, $info;

    function SetupSerialize(array &$props) {
      parent::SetupSerialize($props);

      $props['str'][] = 'entity';
      $props['hash'][] = 'info';
    }

  static function FindTokenCallback($doc, &$raw, &$positions, &$stack, &$token, &$pos, &$flags) {
    $entity = substr($token, 2, -1);
    if (isset( $doc->settings->entities[$entity] ) or self::IsNumericEntity($entity)) {
      return array($entity);
    } else {
      return Uwacko_SkipThisToken;
    }
  }

    static function IsNumericEntity($entity) {
      return mb_strlen($entity) <= 7 and ltrim($entity, '0..9') === '';
    }

  function SetSettingsFrom(&$raw) {
    $entity = $this->entity = $this->callbackResult[0];

    if (self::IsNumericEntity($entity)) {
      $this->info = array('code' => $entity);
    } else {
      $this->info = $this->settings->entities[$entity];
    }
  }

  function SelfToHtmlWith($contents) {
    return isset($this->info['symbol']) ? $this->info['symbol'] : '&#'.$this->info['code'].';';
  }
}

abstract class Uwacko_SingleTag extends Uwacko_Base {
  public $isSingleHtmlTag = true;
}

  class Uwacko_HorizRule extends Uwacko_SingleTag {
    static $rules = array('-' => 'thin', '=' => 'thick',
                          '*' => 'dotted', '~' => 'curvy');

    public $isBlock = true;
    public $htmlTag = 'hr';

    function Parse() {
      $char = ltrim($this->startToken);
      $char = $char[0];

      $this->htmlClasses[] = $this->RealStyleBy( self::$rules[$char] );
    }
  }

  class Uwacko_ForcedLineBreak extends Uwacko_SingleTag {
    public $htmlTag = 'br';

    function SelfToHtmlWith($contents) {
      return parent::SelfToHtmlWith($contents)."\n<span class=\"forced-break\"></span>";
    }
  }
