<?php
/*
  This pseudo-action reconverts input document into another encoding that iconv() supports.
  Needs php_iconv. Only works if is put right in the beginning of a document. Example:
    {{Charset win-1251}}
    == Документ ==
    Текст...
*/

class Ucharset_Root extends UWikiBaseAction {
  /* It's just a stub class so {{charset}} action will be valid. */

  function Execute($format, $params) { }
}

// Note that we cheat a little here because it's impossible to check whether wacko markup
// is loaded when given $doc is parsed - for example, if markup was loaded after setting
// source (which is fine). $beforeParsingHooks can't be used because regexps that are
// used by UWikiDocument after setting source but before parsing will fail.
array_unshift( UWikiDocument::$setSourceHooks, array('UWikiDocCharsetConvertor', 'Source') );
array_unshift( UWikiDocument::$quoteHooks, array('UWikiDocCharsetConvertor', 'Quote') );
array_unshift( UWikiDocument::$getTitleHooks, array('UWikiDocCharsetConvertor', 'GetTitle') );

class UWikiDocCharsetConvertor {
  const DefaultErrorMsg = '//%%%%{{Charset}}%%%% cannot convert this document from %s to UTF-8.//';

  static function Convert(&$source, $errorMsg = null) {
    static $start = '{{charset ';
    static $end = '}}';

    if (strtolower( substr($source, 0, strlen($start)) ) === $start) {
      if ($endPos = strpos(substr($source, 0, 60), $end)) {
        $charset = substr($source, strlen($start), $endPos - strlen($start));
        $source = iconv($charset, 'UTF-8//IGNORE', $source);

        if ($source === false) {
          $errorMsg or $errorMsg = self::DefaultErrorMsg;
          $source = sprintf($errorMsg, $charset);
        }
      }
    }
  }

    static function Source(&$source, $doc) {
      self::Convert( $source, @$doc->settings->strings['{{charset: cannot convert'] );
    }

    static function Quote(&$str, &$format) {
      $format === 'wacko' and self::Convert($str);
    }

    static function GetTitle(&$gotTitle, &$doc, &$markup, &$quick) {
      if ($markup === 'wacko') {
        $msg = $doc instanceof UWikiDocument ? @$doc->settings->strings['{{charset: cannot convert'] : null;
        self::Convert($doc, $msg);
      }
    }
}
