<?php
/*
  This actions changes a property of UWikiSetting belonging to the calling document.
  Note that the property must be of a scalar type (int, float, str and bool)..
  It can also set modes. Property names are case-sensitive (but you can still use
  an upper-case first letter), mode names are not.
  You can also pass any kind of name in lower case if you put a space before capitalized letters.

    {{Setting noLineBreaksInsideParagraph}}             - sets $noLineBreaksInsideParagraph to True
    {{Setting noLineBreaksInsideParagraph=false}}       - "false", "no", "off" and "0" are all boolean False
    {{Setting no line breaks inside paragraph=0}}
    {{Setting WackoWikiHighlDir=""}}                    - disables WackoWiki highlighters; note
                                                          that first "W" is uppercase - it's converted
                                                          to lowercase automatically
    {{Setting DraftMode, inlineFootnotesAs=expanded}}   - multiple mode/prop assignments
    {{Setting novel}}                                   - you can omit "Mode" when setting a mode
*/

class Usetting_Root extends UWikiBaseAction {
  public $runsImmediately = true;

  function Execute($format, $params) {
      $settings = $format->settings;

    foreach ($params as $prop => $value) {
      $prop = preg_replace('/\s(\w)/e', 'strtoupper("\\1")', $prop);
      isset($settings->$prop) or $prop[0] = strtolower( $prop[0] );

      if (isset($settings->$prop) and is_scalar($settings->$prop)) {
          $prop = &$settings->$prop;

        if (is_bool($prop)) {
          $value = strtolower($value);
          $prop = self::ToBool($value);
        } elseif (is_numeric($prop)) {
          $prop = (int) $value;
        } elseif (is_float($prop)) {
          $prop = (float) $value;
        } else {
          $prop = $value;
        }
      } elseif (strpos($prop, '[') !== false) {
        list($prop, $key) = explode('[', $prop, 2);
        if (is_array($settings->$prop) and !self::IsEmptyStr($key)) {
          $prop = &$settings->$prop;
          $key = rtrim($key, ']');

          if ($value === 'null') {
            unset( $prop[$key] );
          } else {
            $prop[$key] = $value;
          }
        }
      } else {
        substr(strtolower($prop), -4) === 'mode' or $prop .= 'mode';
        method_exists($settings, $prop) and $settings->$prop( self::ToBool($value) );
      }
    }
  }

    static function ToBool($str) {
      static $falses = array('false' => 1, 'no' => 1, 'off' => 1);
      return !empty($str) and empty($falses[$str]);
    }
}
