<?php


abstract class InfoTask extends BaseTask {
  public $header, $listIsEmpty, $listHeader, $rowPattern;
  public $listOnce = true;

  function Run() {
    echo strtoupper($this->header)."\n";

    $doc = $this->cl->CreateUWikiDocument('');

    while (($list = $this->ListBy($doc)) !== false) {
      if (!IsEmptyStr($this->listHeader)) { echo "\n".$this->listHeader."\n"; }

      if (empty($list)) {
        echo '    **'.$this->listIsEmpty."**\n";
      } else {
        printf( "\n  %s\n  %s\n", $this->TableHeader(), str_repeat('-', 76) );

        foreach ($list as $key => $value) {
          $args = $this->RowBy($key, $value);
            array_unshift($args, '  '.$this->rowPattern."\n");
          call_user_func_array('printf', $args);
        }
      }

      if ($this->listOnce) { break; }
    }
  }

    abstract function ListBy($doc);
    abstract function TableHeader();
    abstract function RowBy($key, $value);
}

  UWikiTask::$tasks[] = 'ListHandlersTask';
  class ListHandlersTask extends InfoTask {
    const MaxTokenLength = 33;

    public $header = 'Defined handlers';
    public $listIsEmpty = 'No handlers';
    public $rowPattern = '%38s | %s';
    public $listOnce = false;

    public $handlers;

    static function CanHandle($cl) { return !empty( $cl->options['list-handlers'] ); }

    function __construct($cl) {
      parent::__construct($cl);
      $this->handlers = $cl->options['list-handlers'];
    }

    function ListBy($doc) {
      if ($handler = array_shift($this->handlers)) {
        list($markup, $group) = explode(',', $handler);
        if (IsEmptyStr($group)) {
          $group = $markup;
          $markup = 'wacko';
        }

          $doc = $this->cl->CreateUWikiDocument('', $markup);

        $this->listHeader = "...of markup $markup, $group group:";
        return $doc->settings->handlers->Get($group);
      } else {
        return false;
      }
    }

    function TableHeader() { return sprintf($this->rowPattern, 'CLASS NAME', 'TOKEN REGEXP (... - SHORTENED)'); }

    function RowBy($i, $handler) {
      $token = $handler[0];
      $token = strlen($token) > self::MaxTokenLength ? substr($token, 0, self::MaxTokenLength).'...' : $token;

      return array($handler[1], $token);
    }
  }

  UWikiTask::$tasks[] = 'ListReplacementsTask';
  class ListReplacementsTask extends InfoTask {
    public $header = 'Text replacements to be performed';
    public $listIsEmpty = 'No replacements';
    public $rowPattern = '%38s | %s';
    public $listOnce = false;

    public $replacements;

    static function CanHandle($cl) { return !empty( $cl->options['list-replacements'] ); }

    function __construct($cl) {
      parent::__construct($cl);
      $this->replacements = $this->cl->options['list-replacements'];
    }

    function ListBy($doc) {
      if ($outFormat = array_shift($this->replacements)) {
        $this->listHeader = "...for output format $outFormat:";
        return $doc->settings->text['replaceWithStr'][$outFormat];
      } else {
        return false;
      }
    }

    function TableHeader() { return sprintf($this->rowPattern, 'PATTERN REGEXP', 'REPLACE WITH'); }
    function RowBy($from, $to) { return func_get_args(); }
  }

  UWikiTask::$tasks[] = 'ListStyleAliasesTask';
  class ListStyleAliasesTask extends InfoTask {
    public $header = 'Style aliases';
    public $listIsEmpty = 'No aliases';
    public $rowPattern = '%38s | %s';

    static function CanHandle($cl) { return !empty( $cl->options['list-style-aliases'] ); }
    function ListBy($doc) { return $doc->settings->styleAliases; }
    function TableHeader() { return sprintf($this->rowPattern, 'ALIAS NAME', 'ALIASED TO (REAL STYLE NAME'); }
    function RowBy($alias, $style) { return func_get_args(); }
  }

  UWikiTask::$tasks[] = 'ListEntitiesTask';
  class ListEntitiesTask extends InfoTask {
    public $header = 'Defined entities';
    public $listIsEmpty = 'No entities';
    public $rowPattern = '%04X %s %21s | %23s / %s';

    static function CanHandle($cl) { return !empty( $cl->options['list-entities'] ); }
    function ListBy($doc) { return $doc->settings->entities; }

    function TableHeader() {
      $pattern = str_replace('%04X', '%s', $this->rowPattern);
      return sprintf($pattern, 'CODE', ' ', 'ENTITY NAME', 'WACKO', 'HTML ENTITY/CHAR');
    }

    function RowBy($entityName, $info) {
      return array( $info['code'], chr($info['code']), $entityName, "&&$entityName;", $info['html'] );
    }
  }
