<?php

class EMultiLangBuildTask extends OtherTaskError { }

  class EWrongIsoCode extends EMultiLangBuildTask {
    public $code;

    function __construct($code) { $this->code = $code; }

    function __toString() {
      return "Language code {$this->code} doesn't appear to be a proper ISO-639 code.\n".
             'All codes are listed at http://www.loc.gov/standards/iso639-2/ascii_8bits.html';
    }
  }

  class EMixedIsoCodes extends EMultiLangBuildTask {
    function __toString() {
      return 'Don\t mix 2- and 3-character ISO codes in one build (see --languages).';
    }
  }

// must be before build task.
array_unshift(UWikiTask::$tasks, 'MultiLangBuildTask');
class MultiLangBuildTask extends BaseTask {
  public $langs;  // format:   array('code' => 'path', ...)

  static function CanHandle($cl) {
    return BuildTask::CanHandle($cl) and ($cl->options['language'] or $cl->options['languages']);
  }

  function CheckEnvironment() {
    $errors = array(
      'Not a single language directory was found.' => empty($this->langs),
      'A same path belong to multiple languages!' =>
        count($this->langs) !== count( array_unique($this->langs) )
    );

    EEnvironmentCheck::ThrowIfAny($errors);
  }

  function Run() {
    $this->FillLanguages();
    $this->CheckEnvironment();

    $i = 0;
    foreach ($this->langs as $code => $path) {
      if ($this->cl->StopOnProgress( count($this->langs), ++$i, compact('code', 'path' ))) {
        break;
      }

      $cl = clone $this->cl;

        $cl->options['language'] = null;
        $cl->options['languages'] = null;

        isset( $cl->byIndex[1] ) or array_unshift($cl->byIndex, null);
        $destDir = rtrim($cl->byIndex[1], '\\/');

      try {
        $cl->byIndex[0] = $path;
        $cl->byIndex[1] = "$destDir/$code";
        $cl->options['Languages'] = $this->langs;
        $cl->options['Current-Language'] = $code;

        $this->PrepareURLsIn($cl, $code);

        $cl->Run();
      } catch (Exception $e) {
        if (!$this->cl->flags['y']) { throw $e; }
      }
    }

    if (get_class($cl->task->destInterface) === 'FileDestInterface') {
      copy(dirname(__FILE__).'/lang-redir.php', $cl->task->destInterface->path.'/../index.php');
      copy(dirname(__FILE__).'/lang-htaccess', $cl->task->destInterface->path.'/../.htaccess');
    }
  }

    function PrepareURLsIn($cl, $language) {
        $vars = compact('language');

      static $urlSubstParams = array('root-url', 'media-url', 'smiley-url',
                                     'source-url', 'history-url');

        foreach ($urlSubstParams as $param) {
          $value = &$cl->options[$param];
          IsEmptyStr($value) or $value = $this->MakeUrlFrom($value, $vars);
        }

      foreach ($cl->options['config-path'] as &$path) {
        $path = $this->MakeUrlFrom($path, $vars);
      }

      foreach ($cl->options['copy'] as &$src) {
        $src = $this->MakeUrlFrom($src, $vars);
      }
    }

      function MakeUrlFrom($template, $vars) {
        return str_replace('{LANG}', $vars['language'], $template);
      }

    function FillLanguages() {
      $this->langs = array();
      $codeLength = null;

      $langs = $this->cl->options['language'];
      is_array($langs) or $langs = array();
      $langs = array_merge($langs, $this->LangGroupsToPaths());

        foreach ($langs as $code => $path) {
          $thisCodeLength = strlen($code);
            if ($thisCodeLength !== 2 and $thisCodeLength !== 3) { throw new EWrongIsoCode($code); }
            if ($codeLength and $codeLength !== $thisCodeLength) { throw new EMixedIsoCodes; }

          $codeLength = $thisCodeLength;
          $this->langs[ strtolower($code) ] = $path;
        }
    }

      function LangGroupsToPaths() {
        $all = array();

        if ($paths = $this->cl->options['languages']) {
          foreach ($paths as $path) {
            // $path = .../**/... or .../***/... or neither - then append **.

            $path = str_replace('***', '???', $path, $isCode3);
            if ($isCode3) {
              $langs = glob($path, GLOB_MARK | GLOB_ONLYDIR);
              $codeRegExp = $this->MakeLangCodeRegExpFor($path, 3);
            } else {
              $path = str_replace('**', '??', $path, $isCode2);
              $isCode2 or $path = rtrim($path, '\\/').'/??';

              $langs = glob($path, GLOB_MARK | GLOB_ONLYDIR);
              $codeRegExp = $this->MakeLangCodeRegExpFor($path, 2);
            }

            foreach ($langs as &$path) {
              if (preg_match($codeRegExp, $path, $code)) {
                $all[ $code[1] ] = $path;
              }
            }
          }
        }

        return $all;
      }

        function MakeLangCodeRegExpFor($path, $iso) {
          $pattern = $iso === 2 ? '\\?\\?' : '\\?\\?\\?';
          return '~^'.str_replace($pattern, "([a-z]{{$iso}})", preg_quote($path, '~')).'[\\\\/]?$~i';
        }
}
