<?php
  $selfUpDirsToEngineRoot = 1;
  require '../engine/page.php';

  // todo: move admin and other pages to classes (as by-filter, ... are). ?>
  <h1> <a href="plugins.php">Plugins</a> </h1>

  <form action="plugins.php" method="get">
    <strong>Uninstall by name</strong> (also cleans trails of corrupted installations):
    <input type="text" name="uninstall" value="" />
    <input type="submit" value="Uninstall" />
  </form>

  <form action="plugins.php" method="get">
    <strong>Install by path:</strong>
    <input type="text" name="file" size="100" />
    <input type="submit" name="install" value="Install" />
    <input type="submit" name="overwrite" value="Overwrite" />

    <p>
      <strong>Warning:</strong>
      <kbd>Overwriting</kbd> is like normal installation but in case of already existing files they will be replaced even if those which were modified after they were installed previously.
    </p>
  </form>

  <?php
  if ($plugin = &$_REQUEST['uninstall']) {
    echo '<h2>Uninstalling ', Plugins::CaptionOf($plugin), '</h2>',
         '<h3>The plan:</h3>';

    if (isset( BEvent::$list['on plugin uninstall'] )) {
      echo '<ol>';
      foreach (BEvent::$list['on plugin uninstall'] as $func) {
        echo '<li>', is_array($func) ? "$func[1]() of $func[0]" : "$func()", '</li>';
      }
      echo '</ol>';
    }

    function UninstDiffChecksum($plugin, $file, $current, $md5) { ?>
      <strong><?php echo basename($file)?></strong> differs from the one that was installed (got
      <em><?php echo $current?></em>, was <em><?php echo $md5?></em>) &ndash;
      <a href="plugins.php?unlink=<?php echo urlencode($file), '&md5=', $current?>">remove anyway</a>.
    <?php }

    Plugins::Uninstall($plugin, array('diffChecksumCallback' => 'UninstDiffChecksum'));
    echo '<h4>Done.</h4>';
  }
  if ($file = &$_REQUEST['unlink']) {
    if (md5_file($file) === $_REQUEST['md5']) {
      unlink($file);
      RemoveEmptyDirsAbove(dirname($file));
      echo '<em>Removed ', $file, '</em>';
    } else {
      die("Hash differs: need \"".$_REQUEST['md5']."\", actual was \"".md5_file($file)."\".");
    }
  }

  if ($plugin = &$_REQUEST['install']) {
    echo '<h2>Installing ', htmlspecialchars8($_REQUEST['file']), '</h2>';
    Plugins::Install($_REQUEST['file']);
    echo '<h4>Done</h4>';
  }
  if ($plugin = &$_REQUEST['overwrite']) {
    echo '<h2>Overwriting ', htmlspecialchars8($_REQUEST['file']), '</h2>';
    Plugins::Install($_REQUEST['file'], 'overwrite');
    echo '<h4>Done</h4>';
  }
  if ($plugin = &$_REQUEST['join']) {
    try {
      echo '<h2>Joined-back setup file of ', Plugins::CaptionOf($plugin), ' [ it\'s UTF-8! ]</h2>',
           '<textarea readonly="readonly" rows="20" style="width: 100%" onfocus="this.select();">',
           htmlspecialchars8( Plugins::JoinBack($plugin) );
    } catch (Exception $e) { $ex = $e; }
    echo '</textarea>';
    if (isset($e)) { throw $e; }
  }

  echo '<h2>Installed plugins</h2>';
  if (!Plugins::IsAnyInstalled()) {
    echo '<em>No plugins are currently installed.</em>';
  } else {
    echo '<ol style="list-style: upper-roman">';

      function FileList($files, $default = '') {
        if ($files) {
          $result = $default ? '' : '<strong>User files:</strong>';
          $result .= '<ol>';

          $root = BConfig::$enginePath;
          foreach ($files as $file => $md5) {
            if ($default) {
              $md5 = " [$md5]";
            } else {
              $file = $md5;
              $md5 = '';
            }

            strpos($file, $root) === 0 and $file = substr($file, mb_strlen($root));
            $result .= "<li>$file$md5</li>";
          }

          return "$result</ol>";
        } else {
          return $default;
        }
      }

    foreach (Plugins::All() as $plugin => $info) {
      $files = '';

      $pluginEnc = urlencode($plugin);
      echo '<li>',
           '<strong>', Plugins::CaptionOf($plugin), '</strong>',
           ' &ndash; <a href="plugins.php?uninstall=', $pluginEnc.'">uninstall</a>,',
           '         <a href="plugins.php?join=', $pluginEnc, '">join back</a>.',
           FileList( $info['files'], ' <em>Plugin has no files</em>.' ),
           FileList( Plugins::UserFilesOf($plugin) ),
           '</li>';
    }

    echo '</ol>';
  }
