<?php
require_once 'engine/page.php';

// $title: post-title[/tail][/action]
$title = trim(@$_REQUEST['title'], '/');
$title = $id = str_replace('//', '/', $title);

  $title = explode('/', $title);
  $action = array_pop($title);
  if (!BPage::ActionExists($action)) {
    $title[] = $action;
    $action = 'list';
  }
  $title = join('/', $title);

$posts = BPosts::AllMatchingUrlTitle($title);

if (!$posts and BTags::Exists($title)) {
  RedirectTo(BTags::UrlOf($title));
} elseif (count($posts) > 1 and
          $tail = Permalink::ParseTail( Permalink::TailFrom($title) )) {
  RedirectTo(BTplVars::DateFilterURL($tail[0], 'd'), 'permanent');
} else {
  $origRequest = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

  $criteria = $title;   // is used if post wasn't found as it switches to 'blog list' page.
  $page = new BPage;
  $criteriaType = 'title';
  $page->Run($action, array( compact('posts', 'origRequest', 'criteria', 'criteriaType', 'title') + $_REQUEST ));
}
