<?php

class BTags {
  static $names = array(null => null);

  static function Count($tag) { return BIndex::SelectFrom('TagCounts', $tag); }
  static function Exists($tag) { return (bool) self::Count($tag); }
  // currently categories are the same as tags.
  static function IsCategory($category) { return self::Exists($category); }
  static function PopularityOf($tag) { return 0.5; }

  static function UrlOf($tag) {
    return BConfig::$siteHome.'='.urlencode($tag);
  }

  static function LoadConfig($config) {
    static $configs = array();

    $config = BConfig::$paths['config']."/$config.conf";
    if (!isset( $configs[$config] )) {
      $configs[$config] = LoadKeyValuesFrom($config, '=');
    }

    return $configs[$config];
  }

  static function GetNamePartOf($tag, $part, $default = null) {
    self::LoadNames();

    $tag = mb_strtolower($tag);

    if (isset(self::$names[$tag][$part])) {
      return self::$names[$tag][$part];
    } else {
      return $default;
    }
  }

    static function LoadNames() {
      if (self::$names[null] !== BConfig::$paths['config']) {
        $names = array();

          $config = self::LoadConfig('tags');
          foreach ($config as $tag => &$name) {
            @list($caption, $desc) = explode('|', $name);
            $caption = rtrim($caption);
            $desc = isset($desc) ? ltrim($desc) : '';

            $names[ mb_strtolower($tag) ] = compact('caption', 'desc');
          }

        $names[null] = BConfig::$paths['config'];
        self::$names = $names;
      }
    }

  static function CaptionOf($tag) { return self::GetNamePartOf($tag, 'caption', $tag); }
  static function ShortDescOf($tag) { return self::GetNamePartOf($tag, 'desc'); }

  static function Translate(array $tags) {
    foreach ($tags as &$tag) { $tag = BTags::CaptionOf($tag); }
    return $tags;
  }

  static function DescOf($tag) {
    $desc = BEvent::FireResult('string', 'tag desc', array($tag));
    isset($desc) or $desc = self::ShortDescOf($tag);
    return $desc;
  }

    static function GetHtmlDescOf(&$desc, $tag) {
      $tag = BConfig::FromUTF8('file name', mb_strtolower($tag));
      $file = BConfig::$paths['config']."tags/$tag.html";
      if (is_file($file)) {
        $desc = file_get_contents($file);
        return true;
      }
    }

    static function GetWikiDescOf(&$desc, $tag) {
      $name = 'tags/'.mb_strtolower($tag).'.wiki';
      $file = BConfig::FileOf( 'config', BConfig::FromUTF8('file name', $name) );
      $desc = WikiCache::Get($name, $file);
      if ($desc !== null) { return true; }
    }
}
