<?php
// array of posts written within given date (or month/year, below).
class DatedayFileIndex extends BaseHashOfArraysFileIndex {
  public $format = 'd-m-y';
  public $indexName = 'date-day';

  function Select($timestamp) {
    $key = date($this->format, $timestamp);
    return parent::Select($key);
  }

  function Add($timestamp, $post) {
    $key = date($this->format, $timestamp);
    parent::Add($key, $post);
  }

  function Remove($timestamp, $post) {
    $key = date($this->format, $timestamp);
    parent::Remove($key, $post);
  }

  function Rename($timestamp, $post, $newPost) {
    $key = date($this->format, $timestamp);
    parent::Rename($key, $post, $newPost);
  }

  function PostAdded($post, &$doc) {
    $this->Add($doc['dateWritten'], $post);
  }

  function PostDeleted($post, &$doc) {
    $this->Remove($doc['dateWritten'], $post);
  }

  function PostMoved($post, $newName, &$doc) {
    $this->Rename($doc['dateWritten'], $post, $newName);
  }

  function Rebuild() {
    $this->Clear();

    foreach (BPosts::All() as $post) {
      $this->Add(BPosts::Get($post, 'dateWritten'), $post);
    }
  }
}
