<?php
// a collection of some fields gathered from UWikiDocument upon formatting.
class PostdocsFileIndex extends BaseFileIndex {
  static $loadedPostFiles = array();

  public $modified = false;
  public $group = 'post';

  function Flush() {
    if ($this->modified) {
      $this->modified = false;
      foreach (self::$loadedPostFiles as $file) { self::Save($file); }
      self::$loadedPostFiles = array();
    }
  }

    function DocFileOf($post) { return $this->group.'-docs/'.$post; }

  function Select($post, $key = null) {
    return self::From( $this->DocFileOf($post), $key );
  }

  function Add($post, $doc) {
    unset($doc['doc']);

    $file = $this->DocFileOf($post);
    self::$loaded[$file] = $doc;
    self::$loadedPostFiles[] = $file;
    $this->modified = true;
  }

  function Remove($post) {
    $file = $this->DocFileOf($post);

    unlink(self::FileOf($file));
    self::$loaded[$file] = null;

    $i = array_search($file, self::$loadedPostFiles);
    if ($i !== false) { unset( self::$loadedPostFiles[$i] ); }
  }

  function Rename($post, $newPost) {
    $this->Add($newPost, $this->Select($post));
    $this->Remove($post);
  }
}
