<?php

class Shortener {
  static $inlineDelims = " \n-_().";

  static function Shorten($doc, $length, &$options) {
    $doc->BeginRenderingInto('html');
    $shortened = self::ShortenChildrenOf($doc->root, $length, $options['softLimit'],
                                         $options['isTruncated']);
    $doc->EndRenderingInto('html', $shortened);

      if ($options['isTruncated'] and $fullURL = $options['fullURL']) {
        $shortened .= '<p style="font-weight: bold">
                         <a href="'.$fullURL.'">&laquo;&hellip;&raquo;</a>
                       </p>';
      }

    return $shortened;
  }

  static function ShortenChildrenOf($node, $length, $softLimit, &$isTruncated) {
    $children = $node->children;

    static $skipKinds = array('heading' => 1, 'format' => 1);
    $i = -1;
    while (isset($children[++$i]) and isset($skipKinds[ $children[$i]->kind ])) { }

    if (isset($children[$i]) and $children[$i]->htmlTag === 'blockquote') {
      $content = self::ShortenChildrenOf($children[$i], $length, $softLimit, $isTruncated);
      return $children[$i]->SelfToHtmlWith($content);
    } else {
      $result = self::HtmlForFirst($length, $children);

        if (!empty($children)) {
          $softResult = self::HtmlForFirst($softLimit, $children);
          // if there were more elements than even with soft shortening - discard them.
          empty($children) and $result .= $softResult;
        }

      $isTruncated = ($result !== '' and !empty($children));
      return $result;
    }
  }

  static function HtmlForFirst($count, &$children) {
    static $skipKinds = array('anchor' => 1, 'format' => 1, 'footnote' => 1);

    $result = '';
    $count <= 0 and $count = -1;

      while ($count !== 0 and !empty($children)) {
        $child = array_shift($children);
        $html = $child->AllToHTML();

        if (trim($html) !== '' and !isset( $skipKinds[$child->kind] ) and
            ($count > 0 or $child->kind !== 'heading')) {
          --$count;
          $result .= $html;
        }
      }

    return $result;
  }

  static function ShortenInlineDoc(UWikiDocument $doc, array $options) {
    $options += array('max' => 150, 'soft' => 10, 'cut' => '…',
                      'paragraph' => ' &nbsp;',
                      'skip' => array('anchor', 'format', 'footnote'));

      if (!is_array($options['skip'])) {
        $options['skip'] = explode(',', strtolower($options['skip']));
        foreach ($options['skip'] as &$kind) { $kind = trim($kind); }
      }
      $options['skip'] = array_flip(array_filter($options['skip']));

    $result = '';
    $nodeI = -1;

      $doc->BeginRenderingInto('html');

      while ($nodeI + 1 < count($doc->root->children)) {
        if ($options['max'] <= 0) {
          $options['max'] === 0 and $result .= $options['cut'];
          break;
        }

        $html = self::InlineHtmlFrom($doc->root->children[++$nodeI], $options);

        if ($html !== '') {
          $html = self::ShortenInlineHTML($html, $options);

          $result === '' or $result .= $options['paragraph'];
          $result .= $html;
        }
      }

      $doc->EndRenderingInto('html', $result);

    return $result;
  }

    static function &InlineHtmlFrom(UWikiBaseElement $node, array &$options) {
      $html = '';

      if ($node->kind === 'paragraph') {
        foreach ($node->children as $paragraphLine) {
          foreach ($paragraphLine->children as $child) {
            if ($child->htmlTag === 'br') {
              $html .= ' ';
            } elseif (!isset($options['skip'][ $child->kind ])) {
              $html .= $child->AllToHTML();
            }
          }
        }
      }

      return $html;
    }

    static function &ShortenInlineHTML(&$html, array &$options) {
      $result = '';

        $max = &$options['max'];
        $tagEnd = 0;
        $opTags = array();
        $tag = null;

          @list($text, $html) = explode('<', $html, 2);
           while (true) {
            if ($tag !== null) {
              if ($tag[0] === '/') {
                if ($opTags[0] !== substr($tag, 1)) {
                  throw new BException('Cannot shorten inline - wrong nesting of tags'.
                                       ' in rendered HTML.');
                } else {
                  array_shift($opTags);
                }
              } else {
                array_unshift($opTags, strtok($tag, ' '));
              }
            }

            $len = mb_strlen($text);
            $len > $max and $text = ShortenInlineText($text, $options);
            $result .= $text;
            $max -= $len;

            if ($max <= 0 or !isset($html[0])) {
              break;
            }

            @list($tag, $html) = explode('>', $html, 2);
            $result .= "<$tag>";

            @list($text, $html) = explode('<', $html, 2);
          }

        $opTags and $result .= '</'.join('></', $opTags).'>';

      return $result;
    }

  static function ShortenInlineText($str, array $options) {
    $options += array('max' => 150, 'soft' => 10, 'cut' => '…',
                      'paragraph' => ' ');

    $lastDelim = null;

    if (mb_strlen($str) > $options['max']) {
      $str = mb_substr($str, 0, $options['max']);
      $pos = -1 * $options['soft'];
      do {
        $sub = mb_substr($str, ++$pos);
        $sub = strpbrk($sub, self::$inlineDelims);
        $sub === false or $lastDelim = -1 * mb_strlen($sub);
      } while ($sub !== false and $pos);

      $lastDelim and $str = mb_substr($str, 0, $lastDelim);
      $str .= $options['cut'];
    }

    return str_replace("\n", $options['paragraph'], $str);
  }
}
