<?php
// array of posts tagged with given tag.
class TagsFileIndex extends BaseHashOfArraysFileIndex {
  public $indexName = 'tags';

  function Select($tag) { return parent::Select( mb_strtolower($tag) ); }
  function Add($tag, $post) { parent::Add( mb_strtolower($tag), $post ); }
  function Remove($tag, $post) { parent::Remove( mb_strtolower($tag), $post ); }
  function Rename($tag, $post, $newPostName) { parent::Rename( mb_strtolower($tag), $post, $newPostName ); }

  function PostAdded($post, $doc) {
    foreach ($doc['tags'] as $tag) { $this->Add($tag, $post); }
  }

  function PostUpdated($post, $doc, $oldDoc) {
    $this->PostDeleted($post, $oldDoc);
    $this->PostAdded($post, $doc);
  }

  function PostDeleted($post, $doc) {
    foreach ($doc['tags'] as $tag) { $this->Remove($tag, $post); }
  }

  function PostMoved($post, $newName, &$doc) {
    foreach ($doc['tags'] as $tag) { $this->Rename($tag, $post, $newName); }
  }

  function Rebuild() {
    $this->Clear();

    foreach (BPosts::All() as $post) {
      foreach (BPosts::Get($post, 'tags') as $tag) { $this->Add($tag, $post); }
    }
  }
}
