<?php
if (!defined('BlogRootPath')) {
  $root = $_SERVER['SCRIPT_FILENAME'];

    isset($selfUpDirsToEngineRoot) or $selfUpDirsToEngineRoot = 0;
    while (--$selfUpDirsToEngineRoot >= -1) { $root = dirname($root); }

  define('BlogRootPath', "$root/");
  chdir($root);
}

require_once dirname(__FILE__).'/core.php';
require_once dirname(__FILE__).'/events.php';

BEvent::Hook('on generate', array('BPage', 'Generate'));
BEvent::Hook('on output', array('BPage', 'Output'));

class BPage {
  public $action, $args;
  public $mime = 'text/html', $charset = 'utf-8', $body;
  public $isRobotClient, $wasOutput = false;

  // todo: this solution is meant for rewriting - it uses global variable and even
  //       those vars are set by by-filter/title.php and are not meant to be read.
  static function Current() {
    global $isMainPage, $criteriaType, $page;

    if (!empty($isMainPage)) {
      return 'main';
    } elseif (is_object($page) and $page->action === 'thread') {
      return 'blog comments';
    } elseif (isset($criteriaType)) {
      return $criteriaType === 'title' ? 'blog post' : 'blog list';
    }
  }

    static function CurrentPost() {
      global $posts;

      if (self::Current() === 'blog post' and is_array($posts)) {
        return $posts[0];
      }
    }

    static function CurrentEx() {
      $cur = self::Current();

        if ($cur) {
          $curPost = self::CurrentPost();
          if ($curPost and !BPosts::Get($curPost, 'category')) {
            $cur .= ' without category';
          }
        }

      return $cur;
    }

  static function ActionExists($action) {
    return BEvent::Exists("generate page: $action");
  }

  static function Generate(&$page) {
    if (!self::ActionExists($page->action)) {
      throw new BException('No handler is registered for page-action "'.$page->action.'".');
    }

    $args = array_merge(func_get_args(), $page->args);
    BEvent::Fire('generate page: '.$page->action, $args);
  }

  static function Output(&$page) { echo $page->body; }

  function __construct() {
    $this->InitDefaultFields();
  }

    function InitDefaultFields() {
      $this->isRobotClient = IsRobotAgent();
    }

  function FillAs($name, $vars) {
    $vars += array('pageName' => $name);

    BTplVars::Set('common', $vars);
    BTplVars::BeforeFilling($name, $vars);
    $this->body = BConfig::GetStdTpl()->Fill($name, $vars);
  }

  function Run($action, $args) {
    $this->action = $action;
    $this->args = $args;

    $page = $this;
    BEvent::Fire('on generate', array(&$page));

    // may happen when an 'on generate' handler has called Run() second time (which is fine).
    if (!$this->wasOutput) {
      $this->wasOutput = true;
      BEvent::Fire('on output', array(&$page));
    }
  }
}

function ExceptionHandler($e) { BEvent::Fire('on exception', array($e)); }
set_exception_handler('ExceptionHandler');

BEvent::Fire('on start');

register_shutdown_function(array('BEvent', 'Fire'), 'on end');
