<?php
/* Unlike old WackoWiki's highlighters which are always block UverseWiki's can be inlined. */
include_once 'base_highlighter.php';

class Uphp_Root extends UWikiBaseElement {
  public $isFormatter = true;
  public $isAction = false;
  public $htmlTag = 'code';
  public $htmlClasses = array('format', 'format-php');

  public $language = 'PHP';
  public $formattedHTML;

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);
    $props['str'][] = 'formattedHTML';
  }

  function Parse() {
    if ($format = $this->settings->format) {
      $this->isBlock = $format->blockExpected;
    } else {
      // absense of format chain means it's called directly as a markup, e.g. TryParsing(..., 'scripter')
      $this->isBlock = true;
    }

    $this->isBlock and $this->htmlTag = 'div';
    parent::Parse();
  }

    function SetSettingsFrom(&$code) {
      if (substr($code, -2) === '<?') {
        self::DeleteSubstrIn($code, -2, 2);
      } elseif (strpos($code, '<?') === false) {
        $code = '<? '.$code;
        $removePhpTag = true;
      }

      $html = highlight_string($code, true);
      if (isset($removePhpTag)) {
        $pos = strpos($html, '&lt;?&nbsp;');
        $pos and self::DeleteSubstrIn($html, $pos, 11);
      }

        $html = strtr($html, array('<code>' => $this->isBlock ? '<pre>' : '',
                                   '</code>' => $this->isBlock ? '</pre>' : '',
                                   "\n" => '', "\r" => ''));

      $prefix = "<span class=\"format-name\">{$this->language}</span>";
      $prefix = "<span class=\"format-name\">{$this->language}</span>";
      $this->formattedHTML = $prefix.$html;
    }

  function SelfToHtmlWith($html) {
    return parent::SelfToHtmlWith($this->formattedHTML);
  }
}

class Upascal_Root extends UWikiBaseHighlighter {
  public $langName = 'pascal';

  public $constructs = array(
    'string' => array(array("'", "'", true)),
    'directive' => array(array('\{\$', '\}'), array('\(\*\$', '\*\)')),
    'comment' => array(array('//', '$'), array('\(\*', '\*\)', true), array('\{', '\}', true)),
    'char' => array('#\$[a-fA-F0-9]{0,4}', '#(?:\d\d){0,2}'),
    'number' => array('\$[a-fA-F0-9]+', '\b\d+\b')
  );

  public $keywords = array('absolute', 'abstract', 'and', 'array', 'as', 'asm',
                           'begin', 'case', 'class', 'const', 'constructor', 'default',
                           'destructor', 'dispinterface', 'div', 'do', 'downto',
                           'else', 'end', 'except', 'exports', 'external', 'file',
                           'finalization', 'finally', 'for', 'function', 'goto', 'if',
                           'implementation', 'inherited', 'initialization', 'inline',
                           'interface', 'is', 'label', 'library', 'loop', 'message',
                           'mod', 'nil', 'not', 'object', 'of', 'or', 'out',
                           'overload', 'override', 'packed', 'private', 'procedure',
                           'program', 'property', 'protected', 'public', 'published',
                           'raise', 'read', 'record', 'repeat', 'resourcestring',
                           'set', 'shl', 'shr', 'stdcall', 'string', 'then',
                           'threadvar', 'to', 'try', 'type', 'unit', 'until', 'use',
                           'uses', 'var', 'virtual', 'while', 'with', 'write', 'xor');
  public $anyCaseKeyword = true;

  function CSS() {
    return <<<CSS
$ .string { color: blue; }
$ .directive { color: green; }
$ .comment { color: #4D4D4D; font-style: italic; }
$ .number, $ .char { color: navy; }
$ .keyword { font-weight: bold; }
CSS;
  }
}

class Uxml_Root extends UWikiBaseHighlighter {
  public $langName = 'xml';

  public $constructs = array(
    'doctype' => array(array('&lt;!DOCTYPE', '&gt;', true)),
    'xmldecl' => array('&lt;\?xml', '\?&gt;'),
    'comment' => array(array('&lt;!--', '--&gt;', true)),
    'tag' => array(array('(?<=&lt;/|&lt;)\w+\b')),
    'single' => array('/(?=&gt;)'),
    'string' => array(array("'", "'"), array('"', '"')),
    'attribute' => array(array('\w+(?=="|=\')')),
    'entity' => array(array('&amp;', '\w+;'))
  );

  function CSS() {
    return <<<CSS
$ .doctype { color: #3798BE; }
$ .xmldecl { font-weight: bold; }
$ .comment { color: #4D4D4D; font-style: italic; }
$ .tag { font-weight: bold; color: maroon }
$ .single { color: red; }
$ .string { color: blue; }
$ .attribute { font-weight: bold; }
$ .entity { color: navy; }
CSS;
  }
}

class Ucss_Root extends UWikiBaseHighlighter {
  public $langName = 'css';

  public $constructs = array(
    'spec' => array('@[\w-]+'),
    'prop' => array('[\w-]+(?=:\W)'),
    'url' => array(array('url\(', '\)')),
    'string' => array(array("'", "'"), array('"', '"')),
    'comment' => array(array('/\*', '\*/', true)),
    'brace' => array('{', '}'),
    'num' => array('\d+(?:px|pt|em|cm|in|%)?', '#[a-fA-F0-9]{1,6}')
  );

  function CSS() {
    return <<<CSS
$ .spec { color: maroon; border: 1px dashed; padding: 0 1px; }
$ .prop { color: green; }
$ .url { color: navy; }
$ .string { color: blue; }
$ .comment { color: #4D4D4D; font-style: italic; }
$ .brace { color: purple; }
$ .num { color: navy; }
CSS;
  }
}

class Uconf_Root extends UWikiBaseHighlighter {
  public $langName = 'conf';

  public $constructs = array(
    'comment' => array(array('^[ \t]*;', '$'), array('^[ \t]*#', '$')),
    'section' => array(array('^[ \t]*\[', '\][ \t]*$')),
    'eq' => array('='),
  );

  function CSS() {
    return <<<CSS
$ .comment { color: green; }
$ .section { background: #FFB95E; padding: 0 0.25em; }
$ .eq { color: blue; }
CSS;
  }
}

class Ulog_Root extends UWikiBaseHighlighter {
  public $langName = 'log';

  public $constructs = array(
    'ro-br' => array(array('\(', '\)')),
    'sq-br' => array(array('\[', ']')),
    'cu-br' => array(array('\{', '}')),
    'quotes' => array(array("'", "'"), array('"', '"')),
    'symbol' => array(array('-'), array('=')),
    'num' => array('\b\d+\b')
  );

  function CSS() {
    return <<<CSS
$ .ro-br { color: #525252; }
$ .sq-br { color: navy; }
$ .cu-br { color: purple; }
$ .quotes { color: blue; }
$ .symbol { color: maroon; }
$ .num { font-weight: bold; }
CSS;
  }
}

class Ush_Root extends UWikiBaseHighlighter {
  public $langName = 'sh';

  public $constructs = array(
    'head' => array(array('^#!', '$')),
    'comment' => array(array('^\s*#', '$'), array('/\*', '\*/', true)),
    'cmd' => array('^[ \t]*[\w\-.]+(?=\s|$)'),
    'string' => array(array("'", "'"), array('"', '"')),
    'num' => array('\b\d+\b'),
    'redir' => array(array('\d?(&lt;|&gt;)(&amp;)?\d?', '$'))
  );

  function CSS() {
    return <<<CSS
$ .head { font-weight: bold; color: maroon; }
$ .comment { color: green; }
$ .cmd { font-weight: bold; }
$ .string { color: blue; }
$ .num { color: navy; }
$ .redir { text-decoration: underline; }
CSS;
  }
}

class Ushell_Root extends UWikiBaseHighlighter {
  public $parameterOrder = array('prompt');

  public $langName = 'shell';
  public $constructs = array( 'prompt' => array(array('^(?:[%#$]|&gt;) ', '$')) );

  function CSS() {
    return '$ .prompt { color: blue; }';
  }

  function Parse() {
    if ($format = $this->settings->format) {
      $prompt = &$format->current['params']['prompt'];
      if ($prompt) {
        $this->constructs['prompt'][0][0] = '^'.preg_quote($prompt, '~');
      }
    }

    parent::Parse();
  }
}

class Uasm_Root extends UWikiBaseHighlighter {
  public $langName = 'asm';

  public $constructs = array(
    // lookahead is there to avoid "&lt;"-s coming from quoting HTML; for example,
    // this input: "PUSH <addr>" will appear as "PUSH &lt;addr&gt;" to the highlighter.
    'comment' => array(array('(?<!&\w\w);', '$')),
    'string' => array(array("'", "'"), array('"', '"')),
    'number' => array('\b\d[a-fA-F0-9]*[hH]?\b'),
    'addr' => array(array('\[', '\]')),
    'operation' => array(array('\b(?:(?i) )\b')),
    'register' => array(array('\b(?:(?i) )\b')),
  );

  public $operations = array('AAA', 'AAD', 'AAM', 'AAS', 'ADC', 'ADD', 'AND', 'ARPL',
                             'BOUND', 'BSF', 'BSR', 'BSWAP', 'BT', 'BTC', 'BTR', 'BTS',
                             'CALL', 'CBW', 'CDQ', 'CLC', 'CLD', 'CLI', 'CLTS', 'CMC',
                              'CMP', 'CMPS', 'CMPXCHG', 'CWD', 'CWDE', 'DAA', 'DAS',
                             'DEC', 'DIV', 'ENTER', 'ESC', 'HLT', 'IDIV', 'IMUL', 'IN',
                             'INC', 'INS', 'INT', 'INTO', 'INVD', 'INVLPG', 'IRET',
                             'IRETD', 'JA', 'JAE', 'JB', 'JBE', 'JC', 'JCXZ', 'JCXZ',
                             'JECXZ', 'JE', 'JG', 'JGE', 'JL', 'JLE', 'JMP', 'JMP',
                             'JNA', 'JNAE', 'JNB', 'JNBE', 'JNC', 'JNE', 'JNG', 'JNGE',
                             'JNL', 'JNLE', 'JNO', 'JNP', 'JNS', 'JNZ', 'JO', 'JP',
                             'JPE', 'JPO', 'JS', 'JZ', 'LAHF', 'LAR', 'LDS', 'LEA',
                             'LEAVE', 'LES', 'LFS', 'LGDT', 'LGS', 'LIDT', 'LLDT',
                             'LMSW', 'LOCK', 'LODS', 'LOOP', 'LOOPE', 'LOOPZ', 'LOOPNZ',
                             'LOOPNE', 'LSL', 'LSS', 'LTR', 'MOV', 'MOVS', 'MOVSX',
                             'MOVZX', 'MUL', 'NEG', 'NOP', 'NOT', 'OR', 'OUT', 'OUTS',
                             'POP', 'POPA', 'POPAD', 'POPF', 'POPFD', 'PUSH', 'PUSHA',
                             'PUSHAD', 'PUSHF', 'PUSHFD', 'RCL', 'RCR', 'REP', 'REPE',
                             'REPZ', 'REPNE', 'REPNZ', 'RET', 'RETF', 'RETN', 'ROL',
                             'ROR', 'SAHF', 'SAL', 'SHL', 'SAR', 'SBB', 'SCAS', 'SETAE',
                             'SETNB', 'SETB', 'SETNAE', 'SETBE', 'SETNA', 'SETC', 'SETE',
                             'SETZ', 'SETG', 'SETNLE', 'SETGE', 'SETNL', 'SETL',
                             'SETNGE', 'SETLE', 'SETNG', 'SETNC', 'SETNE', 'SETNZ',
                             'SETNO', 'SETNP', 'SETPO', 'SETNS', 'SETO', 'SETP', 'SETPE',
                             'SETS', 'SGDT', 'SHL', 'SHLD', 'SHRD', 'SHR', 'SIDT',
                             'SLDT', 'SMSW', 'STC', 'STD', 'STI', 'STOS', 'STR', 'SUB',
                             'TEST', 'VERR', 'VERW', 'WAIT', 'FWAIT', 'WBINVD', 'XCHG',
                             'XLAT', 'XLATB', 'XOR', 'DB', 'DW', 'DD', 'DQ');
  public $registers  = array('EAX', 'EBX', 'ECX', 'EDX', 'ESI', 'EDI', 'ESP', 'EBP', 'EIP',
                             'EFL', 'FST', 'FCW', 'ST0', 'ST1', 'ST2', 'ST3', 'ST4', 'ST5',
                             'ST6', 'ST7', 'MM0', 'MM1', 'MM2', 'MM3', 'MM4', 'MM5', 'MM6',
                             'MM7', 'AX', 'AL', 'AH', 'BX', 'BL', 'BH', 'CX', 'CL', 'CH',
                             'DX', 'DL', 'DH');

  function __construct() {
    parent::__construct();

    $this->JoinKeywords('operation');
    $this->JoinKeywords('register');
  }

    function JoinKeywords($name, $index = 0) {
      $s = &$this->constructs[$name][$index];
      $s = str_replace(' ', join('|', $this->{$name.'s'}), $s);
    }

  function CSS() {
    return <<<CSS
$ .comment { color: green; }
$ .string { color: navy; }
$ .number { color: blue; }
$ .addr { background: yellow; }
$ .operation { font-weight: bold; }
$ .register { color: maroon; }
CSS;
  }
}
