<?php
/*
  Thsi script is include()d before parsing a document; $this points to UWikiSettings which
  contain final settings (unless overriden by hooks) the document will be processed with.
*/

if (!class_exists('UWikiExtraTypography')) {
  UWikiDocument::$loadedHandlers['wacko']['text replace'][] = array('UWikiExtraTypography', 'FillRegExpsInto');
  UWikiDocument::$loadedHandlers['wacko']['text replace'][] = array('UWikiSimpleTypography', 'FillRegExpsInto');

  class UWikiExtraTypography extends UWikiBaseReplacement {
    function Matches() {
      $match = &$this->matches;

      $i = 0;
      while ($match[++$i][1] === -1) { }
      if (!isset($match[$i])) {
        throw new EUverseWiki($this->className.' could not determine regexp index.');
      }

      return array($i - 1, array_slice($match, $i));   // "- 1" is for full match at index 0.
    }

    function SelfToHtmlWith($contents) {
      list($i, $m) = $this->Matches();

        $tail = array_pop($m);
        $tail = $tail[0];

      switch ($i) {
      case 0:  $html = '<span class="num-group-3">'.$m[0][0].'</span>'.
                       '<span class="num-group-2">'.$m[1][0].'</span>'.
                       '<span class="num-group-1">'.$m[2][0].'</span>'.$m[3][0].$tail; break;
      case 4:
        if (strlen($m[0][0]) === 1 and strlen($m[1][0]) === 3 and strlen($m[2][0]) === 0
            and $m[0][0].$m[1][0] <= 2500) {
          // do not format 4 digits - it might be a year (e.g. 2008).
          return $m[0][0].$m[1][0].$tail;
        }

        $html = '<span class="num-group-2">'.$m[0][0].'</span>'.
                '<span class="num-group-1">'.$m[1][0].'</span>'.$m[2][0].$tail;
        break;

      case 7:  $html = $m[0][0].'×'.$m[1][0].$tail; break;
      case 9:  $html = $m[0][0].'±'.$m[1][0].$tail; break;
      case 10: $html = '±'.$m[0][0].$tail; break;
      case 11: $html = $m[0][0].$tail; break;
      case 12: $html = $m[0][0].'°'.$m[1][0].$tail; break;
      case 14: $html = $m[0][0].'<sup>'.$m[1][0].'</sup>'.$tail; break;

      case 16: $html = $m[0][0].'≥'.$m[1][0].$tail; break;
      case 18: $html = $m[0][0].'≤'.$m[1][0].$tail; break;
      case 20: $html = $m[0][0].'≠'.$m[1][0].$tail; break;
      case 22: $html = '≈'.$m[0][0].$tail; break;

      default:  throw new EUverseWiki(__CLASS__." encountered wrong pattern index ($i).");
      }

      return '<span class="nowrap">'.$html.'</span>';
    }

    static function FillRegExpsInto(&$array, $settings) {
      $regexp =
        '/
          (?<='.UWikiLeftWordBoundary.')

          (?:
            ([+-]?\d?\d?\d)(\d\d\d)(\d\d\d)([.,]\d{1,10})?
          | ([+-]?\d?\d?\d)(\d\d\d)([.,]\d{1,10})?

          | ([+-]?\d+)[*xX]([+-]?\d+)
          | (\d\s*)?\+-(\s*\d+)?
          | ( (?: [+-]?\d+[.,]){1,5} \d+ )
          | ([+-]?\d+)[\s^](F|C)
          | \#?(\d+)-?(st|nd|rd|th)

          | ([+-]?\d\s*)>=(\s*\d+)
          | ([+-]?\d\s*)<=(\s*\d+)
          | ([+-]?\d\s*)!=(\s*\d+)
          | ~([+-]?\d+)
          )

          ('.UWikiRightWordBoundary.')
        /ux';

      $array = array($regexp => array(__CLASS__)) + $array;
    }
  }

  class UWikiSimpleTypography extends UWikiExtraTypography {
    function SelfToHtmlWith($contents) {
      list($i, $m) = $this->Matches();

      switch ($i) {
      case 0:  return '…';
      case 1:  return $m[0][0];
      case 2:  return '™';
      case 3:  return '©';
      case 4:  return '®';
      case 5:  return '℮';
      case 6:  return '§';

      case 7:  return $m[0][0].'́';
      case 8:  return $m[0][0].'̀';

      case 9:  return $m[0][0].$m[1][0].$m[2][0];
      case 12: return $m[0][0].'…'.$m[1][0].@$m[2][0];

      default:  throw new EUverseWiki(__CLASS__." encountered wrong pattern index ($i).");
      }
    }

    static function FillRegExpsInto(&$array, $settings) {
      $wordCh = $settings->wordCharacters;

      $regexp =
        '/
          (?:
            ( \.\.\.+ )
          | ([!?]{2})[!?]+
          | \((TM|tm)\)
          | ( \([cC]\) )
          | \(([rR])\)
          | ( \(e\) )
          | (?<!['.$wordCh.']) ( \([sS]\) )

          | (['.$wordCh.'])\(\'\)
          | (['.$wordCh.'])\(`\)

          | (['.$wordCh.'])[ \t]+([?!.]+|[,:])($|[ \t]+['.$wordCh.'])
          | (['.$wordCh.'])\.\.($|[ \t]+['.$wordCh.'])
          )
        /mux';

      $array = array($regexp => array(__CLASS__)) + $array;
    }
  }
}
