<?php
include_once 'inline.php';

    $regexp = '(?<=\r\n|\n) \s* \(\( '.UWacko_Base::PregQuoteX(Uwacko_FootnoteChar).'{1,'.Uwacko_MaxFootnoteChars.'}';
  self::$loadedHandlers[$markup]['block'][] = array($regexp, 'Uwacko_BlockFootnote', Uwacko_StartTag);
  self::$loadedHandlers[$markup]['block'][] = array('\)\) (?:\r?\n)+', 'Uwacko_BlockFootnote', Uwacko_EndTag);

class Uwacko_InlineFootnote extends Uwacko_InlineElement {
  public $kind = 'footnote';
  public $htmlTag = 'span';
  public $htmlClasses = array('inline-footnote');

  function SelfToHtmlWith($contents) {
    if ($this->settings->inlineFootnotesAs === 'block') {
        $footnoteRef = str_repeat(Uwacko_FootnoteChar, Uwacko_MaxFootnoteChars + 1);

      $link = $this->NewElement('Uwacko_Link');
        $link->SetRaw($footnoteRef);
        $link->Parse();

      $footnote = $this->NewElement('Uwacko_BlockFootnote');
        $footnote->startToken = $footnoteRef;
        $footnote->Parse();
        $footnote->children = $this->children;

      if ($this->settings->footnotesAtTheEnd) {
        if (($format = $this->settings->format) and ($topmost = $format->topmostDoc)) {
          $topmost->root->children[] = $footnote;
        } else {
          $this->doc->root->children[] = $footnote;
        }
      } else {
        $this->settings->followingFootnotes[] = $footnote;
      }

      return $link->AllToHTML();
    } else {
      if ($this->settings->inlineFootnotesAs === 'expanded') {
        $html = sprintf($this->strings['expanded footnote'], $this->ChildrenToHTML());
      } else {
        $html = $this->strings['footnote tooltip'];
      }

      return parent::SelfToHtmlWith($html);
    }
  }

    function SelfHtmlAttributes() {
      $attrs = array('class' => 'inline-footnote-'.$this->settings->inlineFootnotesAs);
      // todo: use ToText when we have it.
      if ($this->settings->inlineFootnotesAs === 'tooltip') {
        $attrs['!title'] = strip_tags($this->ChildrenToHTML());
      }
      return $attrs;
    }
}

class Uwacko_BlockFootnote extends Uwacko_BlockElement {
  public $kind = 'footnote';
  public $htmlTag = 'div';
  public $htmlClasses = array('block-footnote');

  public $referrers, $originAnchors = array();
  protected $anchorName;

  function SetupSerialize(array &$props) {
    parent::SetupSerialize($props);
    $props['list'][] = 'originAnchors';
  }

  function SerializeTo(UWikiSerializer $ser) {
    parent::SerializeTo($ser);
    $ser->WriteArrayUsing(array($ser, 'WriteElement'), $this->referrers);
  }

    function UnserializeFrom(UWikiUnserializer $ser) {
      parent::UnserializeFrom($ser);
      $this->referrers = $ser->ReadArrayUsing( array($ser, 'ReadElement') );
    }

  function SetSettingsFrom(&$raw) {
    $raw = $this->UnindentBlockIfNeeds($raw);

    $allReferrers = &$this->settings->footnoteReferrers;
    $noteIndex = strlen($this->startToken) - strlen( rtrim($this->startToken, Uwacko_FootnoteChar) ) - 1;
    if ($noteIndex === 0) {
      $referrers = array_shift($allReferrers);
    } else {
      $referrers = &$allReferrers[$noteIndex];
      unset( $allReferrers[$noteIndex] );
    }

    if (!$referrers) {
      $this->htmlTag = null;
    } else {
      $name = $this->strings['footnote anchor prefix'].$this->settings->nextFootnoteAnchorIndex;
      $this->AnchorizeAs($name);

      $this->referrers = $referrers;
      foreach ($referrers as $i => $obj) {
        $name = $this->strings['footnote origin prefix'].$this->settings->nextFootnoteAnchorIndex;
        $name = $this->originAnchors[] = $this->settings->anchors->UniqueNameFrom($name, $this);
        $this->settings->anchors->Register($name, $this);

        $obj->LinkToFootnote($this, $i);
      }

      ++$this->settings->nextFootnoteAnchorIndex;
    }
  }

    function AnchorizeAs($name) {
      $anchor = $this->NewElement($this->anchorClass, 'sibling');
      $anchor->PointTo($this);
      $anchor->SetUniqueNameFrom($name);
      $anchor->isBlock = true;
      $this->anchorName = $anchor->Name();
    }

  function AnchorName() { return $this->anchorName; }

  function ChildrenToHTML($withAnchor = true) {
    if (!empty($this->children)) {
      $origins = '';
      foreach ($this->originAnchors as $anchor) {
        $anchor = $this->settings->pageForSelfAnchorLinks.'#'.$this->settings->anchorPrefix.$anchor;
        $origins .= '<li><a href="'.$anchor.'">'.$this->strings['footnote origin link'].'</a></li>';
      }

      return "<ul class=\"origins\">$origins</ul>\n\n".
             parent::ChildrenToHTML($withAnchor);
    }
  }

    function SelfHtmlAttributes() {
      return array('id' => $this->AnchorName());
    }
}
